/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEExtractorInjector
extends TileEntityInv {
    public static final int TUBE_SLOT = 0;
    public static final int CYLINDER_SLOT = 1;
    public static final int SPEED_SLOT = 0;
    public static int inputSlots = 2;
    public static int upgradeSlots = 1;

    public TEExtractorInjector() {
        super(inputSlots, 0, 0, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && CoreUtils.hasConsumable((ItemStack)BaseRecipes.test_tube, (ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "extractor_injector";
    }

    public ItemStack tubeSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack cylinderSlot() {
        return this.input.getStackInSlot(1);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public boolean hasTube() {
        return CoreUtils.hasConsumable((ItemStack)BaseRecipes.test_tube, (ItemStack)this.tubeSlot());
    }

    public boolean hasCylynder() {
        return CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)this.cylinderSlot());
    }

    public boolean hasConsumables() {
        return this.hasTube() && this.hasCylynder();
    }

    public int speedUpgrade() {
        return ModUtils.speedUpgrade(this.speedSlot());
    }

    public void func_73660_a() {
    }
}

