/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumElements;
import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ChemicalExtractorRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MaterialCabinetRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ChemicalExtractorRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MaterialCabinetRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEElementsCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorInjector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorReactor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorStabilizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEFluidInputTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEMaterialCabinetBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TEExtractorController
extends TileEntityInv
implements IInternalServer {
    public static final int PURGE_SLOT = 0;
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 3;
    public int intensity = 8;
    public ItemStack filter = ItemStack.field_190927_a;
    public int currentFile = -1;
    public boolean isRepeatable = false;
    public ChemicalExtractorRecipe dummyRecipe;

    public TEExtractorController() {
        super(inputSlots, outputSlots, templateSlots, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEExtractorController.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.intensity = compound.func_74762_e("Intensity");
        if (compound.func_74764_b("Filter")) {
            this.filter = new ItemStack(compound.func_74775_l("Filter"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Intensity", this.getIntensity());
        if (!this.getFilter().func_190926_b()) {
            NBTTagCompound filterstack = new NBTTagCompound();
            this.filter.func_77955_b(filterstack);
            compound.func_74782_a("Filter", (NBTBase)filterstack);
        }
        return compound;
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack purgeSlot() {
        return this.output.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "extractor_controller";
    }

    public int speedFactor() {
        return this.hasInjector() && ModUtils.isValidSpeedUpgrade(this.getInjector().speedSlot()) ? ModUtils.speedUpgrade(this.getInjector().speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return this.hasInjector() && ModUtils.isValidSpeedUpgrade(this.getInjector().speedSlot()) ? ModConfig.speedExtractor / this.getInjector().speedUpgrade() : ModConfig.speedExtractor;
    }

    private static int deviceCode() {
        return EnumServer.EXTRACTOR.ordinal();
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public ArrayList<ChemicalExtractorRecipe> recipeList() {
        return ChemicalExtractorRecipes.extractor_recipes;
    }

    public ArrayList<String> inhibitedList() {
        return ChemicalExtractorRecipes.inhibited_elements;
    }

    public ArrayList<MaterialCabinetRecipe> materialList() {
        return MaterialCabinetRecipes.material_cabinet_recipes;
    }

    public MaterialCabinetRecipe getMaterialList(int x) {
        return this.materialList().get(x);
    }

    public ChemicalExtractorRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.getFilter().func_190926_b()) {
                if (this.getFilter().func_77969_a(stack)) {
                    return true;
                }
            } else {
                for (ChemicalExtractorRecipe recipe : this.recipeList()) {
                    ArrayList inputOreIDs;
                    if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ChemicalExtractorRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(this.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)this.getRecipeList(x).getOredict())) : this.getRecipeList(x).getInput().func_77969_a(this.inputSlot()))) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public ChemicalExtractorRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public ArrayList<String> recipeOutput() {
        return this.isValidRecipe() ? this.getDummyRecipe().getElements() : null;
    }

    public ArrayList<Integer> recipeQuantities() {
        return this.isValidRecipe() ? this.getDummyRecipe().getQuantities() : null;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 && this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    public BlockPos reactorPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 1);
    }

    public TEExtractorReactor getReactor() {
        TEExtractorReactor reactor;
        TileEntity te = this.field_145850_b.func_175625_s(this.reactorPos());
        if (this.field_145850_b.func_180495_p(this.reactorPos()) != null && te instanceof TEExtractorReactor && (reactor = (TEExtractorReactor)te).getFacing() == this.getFacing().func_176734_d()) {
            return reactor;
        }
        return null;
    }

    public boolean hasReactor() {
        return this.getReactor() != null;
    }

    public BlockPos injectorPos() {
        return this.intankPos().func_177967_a(this.isFacingAt(90), 1);
    }

    public TEExtractorInjector getInjector() {
        TEExtractorInjector injector;
        TileEntity te = this.field_145850_b.func_175625_s(this.injectorPos());
        if (this.field_145850_b.func_180495_p(this.injectorPos()) != null && te instanceof TEExtractorInjector && (injector = (TEExtractorInjector)te).getFacing() == this.getFacing().func_176734_d()) {
            return injector;
        }
        return null;
    }

    public boolean hasInjector() {
        return this.getInjector() != null;
    }

    private boolean hasTube() {
        return this.hasInjector() && CoreUtils.hasConsumable((ItemStack)BaseRecipes.test_tube, (ItemStack)this.getInjector().getInput().getStackInSlot(0)) && CoreUtils.hasConsumable((ItemStack)BaseRecipes.graduated_cylinder, (ItemStack)this.getInjector().getInput().getStackInSlot(1));
    }

    public Block getCharger() {
        BlockPos chargerPos = this.reactorPos().func_177972_a(EnumFacing.UP);
        IBlockState chargerState = this.field_145850_b.func_180495_p(chargerPos);
        Block charger = chargerState.func_177230_c();
        if (MachineIO.miscBlocksA(charger, chargerState, EnumMiscBlocksA.EXTRACTOR_CHARGER.ordinal())) {
            return charger;
        }
        return null;
    }

    public boolean hasCharger() {
        return this.getCharger() != null;
    }

    public BlockPos intankPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 2);
    }

    public TEFluidInputTank getIntank() {
        TEFluidInputTank tank;
        TileEntity te = this.field_145850_b.func_175625_s(this.intankPos());
        if (this.field_145850_b.func_180495_p(this.intankPos()) != null && te instanceof TEFluidInputTank && (tank = (TEFluidInputTank)te).getFacing() == this.getFacing().func_176734_d()) {
            return tank;
        }
        return null;
    }

    public boolean hasIntank() {
        return this.getIntank() != null;
    }

    public boolean hasFluids() {
        return this.hasIntank() && this.input.canDrainFluid(this.getIntank().solventTank.getFluid(), this.nitricAcid(), this.calculatedNitr()) && this.input.canDrainFluid(this.getIntank().reagentTank.getFluid(), this.cyanideAcid(), this.calculatedCyan());
    }

    public TEElementsCabinetBase getElementCabinet() {
        TEElementsCabinetBase cabinet;
        BlockPos cabinetPos = this.reactorPos().func_177967_a(this.isFacingAt(270), 1);
        TileEntity te = this.field_145850_b.func_175625_s(cabinetPos);
        if (this.field_145850_b.func_180495_p(cabinetPos) != null && te instanceof TEElementsCabinetBase && (cabinet = (TEElementsCabinetBase)te).getFacing() == this.isFacingAt(270).func_176734_d()) {
            return cabinet;
        }
        return null;
    }

    public boolean hasElementCabinet() {
        return this.getElementCabinet() != null;
    }

    public TEMaterialCabinetBase getMaterialCabinet() {
        TEMaterialCabinetBase cabinet;
        BlockPos cabinetPos = this.field_174879_c.func_177967_a(this.isFacingAt(270), 1);
        TileEntity te = this.field_145850_b.func_175625_s(cabinetPos);
        if (this.field_145850_b.func_180495_p(cabinetPos) != null && te instanceof TEMaterialCabinetBase && (cabinet = (TEMaterialCabinetBase)te).getFacing() == this.isFacingAt(270).func_176734_d()) {
            return cabinet;
        }
        return null;
    }

    public boolean hasMaterialCabinet() {
        return this.getMaterialCabinet() != null;
    }

    private boolean isAssembled() {
        return this.hasElementCabinet() && this.hasMaterialCabinet() && this.hasReactor() && this.hasCharger();
    }

    public TEExtractorStabilizer getStabilizer() {
        TEExtractorStabilizer stabilizer;
        BlockPos stabilizerPos = this.reactorPos().func_177967_a(this.isFacingAt(90), 1);
        TileEntity te = this.field_145850_b.func_175625_s(stabilizerPos);
        if (this.field_145850_b.func_180495_p(stabilizerPos) != null && te instanceof TEExtractorStabilizer && (stabilizer = (TEExtractorStabilizer)te).getFacing() == this.isFacingAt(90).func_176734_d()) {
            return stabilizer;
        }
        return null;
    }

    public boolean hasStabilizer() {
        return this.getStabilizer() != null;
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.injectorPos(), this.getFacing(), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public int powerConsume() {
        int baseConsume = 10 * ModConfig.basePower * this.getIntensity();
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public FluidStack nitricAcid() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.NITRIC_ACID), 1000);
    }

    public int calculatedNitr() {
        return this.getIntensity() > 0 ? this.getIntensity() * ModConfig.consumedNitr : 1;
    }

    public FluidStack cyanideAcid() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.SODIUM_CYANIDE), 1000);
    }

    public int calculatedCyan() {
        return this.getIntensity() > 0 ? this.getIntensity() * ModConfig.consumedCyan : 1;
    }

    public int baseRecovery() {
        return 20;
    }

    public int calculatedRecombination(int amount) {
        return amount * this.recoveryFactor() / 100;
    }

    public int recoveryFactor() {
        return 100 - this.stabilizerNum() * this.getIntensity();
    }

    public int stabilizerNum() {
        return this.hasStabilizer() ? 6 - this.getStabilizer().getBusySlots() : 6;
    }

    public int calculatedDust(int amount) {
        return amount * this.normalRecovery() / 100;
    }

    public int normalRecovery() {
        return this.getIntensity() * 6;
    }

    public int recombinationChance() {
        return this.rand.nextInt(18 - this.getIntensity());
    }

    public int dissolutionChance() {
        return this.getIntensity() * 100 / 18;
    }

    private int getDurabilityModifier(int cat) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getStabilizer().catSlot(cat));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TEExtractorController.deviceCode());
            if (this.inputSlot().func_190926_b() && this.getDummyRecipe() != null) {
                this.dummyRecipe = null;
                this.cooktime = 0;
            }
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.process();
                    this.cooktime = 0;
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.hasIntank()) {
            if (this.getIntank().getFilterSolvent() != this.nitricAcid()) {
                this.getIntank().filterSolvent = this.nitricAcid();
            }
            if (this.getIntank().getFilterReagent() != this.cyanideAcid()) {
                this.getIntank().filterReagent = this.cyanideAcid();
            }
            this.getIntank().filterManualSolvent = null;
            this.getIntank().filterManualReagent = null;
            this.getIntank().isFiltered = true;
        }
    }

    private void handlePurge() {
        if (this.isActive() && !this.inputSlot().func_190926_b() && !this.getFilter().func_190926_b() && !CoreUtils.isMatchingIngredient((ItemStack)this.inputSlot(), (ItemStack)this.getFilter()) && this.output.canSetOrStack(this.purgeSlot(), this.inputSlot())) {
            this.output.setOrStack(0, this.inputSlot());
            this.input.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.getDummyRecipe() != null && this.isAssembled() && this.hasFuelPower() && this.hasTube() && this.hasFluids() && this.handleFilter(this.inputSlot(), this.getFilter()) && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private void process() {
        if (this.getDummyRecipe() != null && this.getDummyRecipe() == this.getCurrentRecipe()) {
            for (int x = 0; x < this.getDummyRecipe().getElements().size(); ++x) {
                int ix;
                boolean isInhibited;
                String recipeDust;
                int y;
                int formulaValue = this.getDummyRecipe().getQuantities().get(x);
                for (y = 0; y < EnumElements.size(); ++y) {
                    recipeDust = this.getDummyRecipe().getElements().get(x);
                    if (!recipeDust.contains(EnumElements.getDust(y))) continue;
                    isInhibited = false;
                    for (ix = 0; ix < this.inhibitedList().size(); ++ix) {
                        if (!recipeDust.matches(this.inhibitedList().get(ix))) continue;
                        isInhibited = true;
                    }
                    if (isInhibited || !this.hasElementCabinet()) continue;
                    if (formulaValue > this.baseRecovery()) {
                        if (this.recombinationChance() == 0) {
                            int n = y;
                            this.getElementCabinet().elementList[n] = this.getElementCabinet().elementList[n] + (this.baseRecovery() + this.calculatedRecombination(formulaValue - this.baseRecovery()));
                            this.handleConsumableDamage();
                        } else {
                            int n = y;
                            this.getElementCabinet().elementList[n] = this.getElementCabinet().elementList[n] + (this.baseRecovery() + this.calculatedDust(formulaValue - this.baseRecovery()));
                        }
                    } else {
                        int n = y;
                        this.getElementCabinet().elementList[n] = this.getElementCabinet().elementList[n] + formulaValue;
                    }
                    this.getElementCabinet().markDirtyClient();
                }
                for (y = 0; y < this.materialList().size(); ++y) {
                    recipeDust = this.getDummyRecipe().getElements().get(x);
                    if (!recipeDust.contains(this.materialList().get(y).getOredict())) continue;
                    isInhibited = false;
                    for (ix = 0; ix < this.inhibitedList().size(); ++ix) {
                        if (!recipeDust.matches(this.inhibitedList().get(ix))) continue;
                        isInhibited = true;
                    }
                    if (isInhibited || !this.hasMaterialCabinet()) continue;
                    if (formulaValue > this.baseRecovery()) {
                        if (this.recombinationChance() == 0) {
                            int n = y;
                            this.getMaterialCabinet().elementList[n] = this.getMaterialCabinet().elementList[n] + (this.baseRecovery() + this.calculatedRecombination(formulaValue - this.baseRecovery()));
                            this.handleConsumableDamage();
                        } else {
                            int n = y;
                            this.getMaterialCabinet().elementList[n] = this.getMaterialCabinet().elementList[n] + (this.baseRecovery() + this.calculatedDust(formulaValue - this.baseRecovery()));
                        }
                    } else {
                        int n = y;
                        this.getMaterialCabinet().elementList[n] = this.getMaterialCabinet().elementList[n] + formulaValue;
                    }
                    this.getMaterialCabinet().markDirtyClient();
                }
            }
            if (this.getIntank().hasSolventFluid() && this.getIntank().getSolventAmount() >= this.calculatedNitr()) {
                this.output.drainOrCleanFluid(this.getIntank().solventTank, this.calculatedNitr(), true);
            }
            if (this.getIntank().hasReagentFluid() && this.getIntank().getReagentAmount() >= this.calculatedCyan()) {
                this.output.drainOrCleanFluid(this.getIntank().reagentTank, this.calculatedCyan(), true);
            }
            int unbreakingLevel = 0;
            unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getInjector().tubeSlot());
            ((MachineStackHandler)this.getInjector().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getInjector().cylinderSlot());
            ((MachineStackHandler)this.getInjector().getInput()).damageUnbreakingSlot(unbreakingLevel, 1);
            this.input.decrementSlot(0);
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        }
        this.dummyRecipe = null;
    }

    private void handleConsumableDamage() {
        if (this.isValidRecipe() && this.hasStabilizer()) {
            for (int x = 0; x < TEExtractorStabilizer.SLOT_INPUTS.length; ++x) {
                if (this.getStabilizer().catSlot(x).func_190926_b()) continue;
                int unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getStabilizer().catSlot(x));
                ((MachineStackHandler)this.getStabilizer().getInput()).damageUnbreakingSlot(unbreakingLevel, x);
            }
        }
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TEExtractorController.deviceCode() && tag.func_74762_e("Recipe") < 16 && tag.func_74762_e("Done") > 0) {
                    if (this.recipeIndex != tag.func_74762_e("Recipe")) {
                        this.recipeIndex = tag.func_74762_e("Recipe");
                        this.markDirtyClient();
                    }
                    if (this.currentFile != x) {
                        this.currentFile = x;
                        this.markDirtyClient();
                    }
                    if (!tag.func_74764_b("FilterStack")) break;
                    ItemStack temp = new ItemStack(tag.func_74775_l("FilterStack"));
                    if (!this.getFilter().func_190926_b() && this.getFilter().func_77969_a(temp)) break;
                    this.filter = temp;
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TEExtractorController.deviceCode());
            }
        }
    }
}

