/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEDisposer
extends TileEntityInv {
    public static final int[] INPUT_SLOT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static int inputSlots = INPUT_SLOT.length;
    public static int templateSlots = 6;
    public List<ItemStack> lockList = new ArrayList<ItemStack>();
    public int interval;
    public boolean lock;

    public TEDisposer() {
        super(inputSlots, 0, templateSlots, 0);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot >= INPUT_SLOT[0] && slot <= INPUT_SLOT.length && insertingStack != null && TEDisposer.this.canPassTheLock(slot, insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.interval = compound.func_74762_e("Interval");
        this.lock = compound.func_74767_n("Lock");
        NBTTagList nbttaglist = compound.func_150295_c("Filter", 10);
        this.lockList = new ArrayList<ItemStack>();
        this.resetLock();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.lockList.size()) continue;
            this.lockList.add(j, new ItemStack(nbttagcompound));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Interval", this.getInterval());
        compound.func_74757_a("Lock", this.isLocked());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.lockList.size(); ++i) {
            if (this.lockList.get(i).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.lockList.get(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Filter", (NBTBase)nbttaglist);
        return compound;
    }

    public ItemStack inputSlot(int slot) {
        return this.input.getStackInSlot(slot);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "disposer";
    }

    public boolean isComparatorSensible() {
        return false;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public void resetLock() {
        for (int i = 0; i < inputSlots; ++i) {
            this.lockList.add(ItemStack.field_190927_a);
        }
    }

    public boolean canPassTheLock(int slot, ItemStack insertingStack) {
        return !this.isLocked() || this.isLocked() && this.lockList.get(slot) != null && this.lockList.get(slot).func_77969_a(insertingStack);
    }

    public void func_73660_a() {
        if (this.lockList.size() < 1) {
            this.resetLock();
        }
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            ++this.cooktime;
            if (this.getCooktime() >= this.getInterval()) {
                this.cooktime = 0;
                this.process();
            }
        }
    }

    private void process() {
        int[] nArray = INPUT_SLOT;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer slot = nArray[i];
            if (this.inputSlot(slot).func_190926_b()) continue;
            ItemStack drop = this.inputSlot(slot).func_77946_l();
            drop.func_190920_e(1);
            this.dropItemStack(drop);
            this.input.decrementSlot(slot.intValue());
        }
    }

    private void dropItemStack(ItemStack itemStack) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockPos dropPos = this.field_174879_c.func_177972_a(this.getFacing().func_176734_d());
        double d0 = (double)dropPos.func_177958_n() + 0.5;
        double d1 = (double)dropPos.func_177956_o() + 0.5;
        double d2 = (double)dropPos.func_177952_p() + 0.5;
        EntityItem entityitem = new EntityItem(this.field_145850_b, d0, d1, d2, itemStack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }
}

