/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.io;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.handlers.Reference;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.BaseRotatingMachine;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineIO
extends BaseRotatingMachine {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public Random rand = new Random();

    public MachineIO(String name, Material material, String[] array, float hardness, float resistance, SoundType stepSound) {
        super("rockhounding_chemistry", name, material, array);
        this.func_149647_a(Reference.RockhoundingChemistry);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(stepSound);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < this.array.length; ++i) {
            if (this.hiddenParts(i)) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    protected boolean hiddenParts(int meta) {
        return false;
    }

    protected boolean baseParts(int meta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkFullBlocks(world, pos, state);
        world.func_175684_a(pos, (Block)this, 1);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkFullBlocks(world, pos, state);
    }

    protected void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        int facingIndex = placer.func_174811_aO().ordinal();
        if (te != null) {
            MachinesUtils.restoreMachineNBT((ItemStack)stack, (TileEntity)te, (int)facingIndex);
        }
    }

    public static boolean miscBlocksA(Block block, IBlockState state, int meta) {
        return block != null && block == ModBlocks.MISC_BLOCKS_A && block.func_176201_c(state) == meta;
    }

    public boolean hasNullifier(EntityPlayer player, EnumHand hand) {
        return !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77969_a(BaseRecipes.tile_nullifier);
    }

    public void handleNullifier(World world, BlockPos pos, EntityPlayer player, EnumHand hand, Block block, int meta) {
        if (this.baseParts(meta)) {
            this.spawnTheBase(world, pos, block);
            this.cleanTheTop(world, pos.func_177984_a());
        } else if (this.hiddenParts(meta)) {
            this.spawnTheBase(world, pos.func_177977_b(), block);
            this.cleanTheTop(world, pos);
        } else {
            this.spawnTheBase(world, pos, block);
        }
    }

    public void cleanTheTop(World world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    public void spawnTheBase(World world, BlockPos pos, Block block) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack stack = new ItemStack(block, 1, meta);
        EntityItem entity = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        world.func_72838_d((Entity)entity);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    public void handleRotation(World world, BlockPos pos, EntityPlayer player, int meta) {
        this.rotateTheBlock(world, pos);
        if (this.baseParts(meta)) {
            this.rotateTheBlock(world, pos.func_177984_a());
        } else if (this.hiddenParts(meta)) {
            this.rotateTheBlock(world, pos.func_177977_b());
        }
    }

    public void rotateTheBlock(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (world.func_180495_p(pos) != null && world.func_180495_p(pos).func_177230_c() instanceof MachineIO && tile != null && tile instanceof TileEntityInv) {
            TileEntityInv machine = (TileEntityInv)tile;
            switch (machine.facing) {
                case 2: {
                    machine.facing = 5;
                    break;
                }
                case 5: {
                    machine.facing = 3;
                    break;
                }
                case 3: {
                    machine.facing = 4;
                    break;
                }
                case 4: {
                    machine.facing = 2;
                    break;
                }
                default: {
                    machine.facing = 2;
                }
            }
            machine.markDirtyClient();
        }
    }
}

