/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.machines.container.COStirredTankTop;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEStirredTankTop;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIStirredTankTop
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guistirredtanktop.png");
    public static ResourceLocation TEXTURE_JEI = new ResourceLocation("rockhounding_chemistry:textures/gui/jei/guistirredtanktopjei.png");
    private final TEStirredTankTop tile;

    public UIStirredTankTop(InventoryPlayer playerInv, TEStirredTankTop tile) {
        super(new COStirredTankTop((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEStirredTankTop.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        String volt;
        String commDescr;
        String solv;
        List tooltip;
        String[] multistring;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiUtils.hoveringArea((int)111, (int)87, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String rf = TextFormatting.GRAY + "Energy: " + TextFormatting.RED + this.tile.powerConsume() + " RF/t";
            String tk = TextFormatting.GRAY + "Process: " + TextFormatting.YELLOW + this.tile.getCooktimeMax() + " ticks";
            String yd = TextFormatting.GRAY + "Yeld: " + TextFormatting.YELLOW + this.tile.getCalculatedYeld() * 2 + " mb/t";
            String sf = TextFormatting.GRAY + "Tier: " + TextFormatting.AQUA + this.tile.speedFactor() + "x";
            multistring = new String[]{sf, tk, yd, rf};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)30, (int)60, (int)16, (int)31, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            solv = TextFormatting.RED + "N/A";
            commDescr = TextFormatting.GRAY + "Primary Solvent:";
            if (this.tile.hasIntank() && this.tile.getIntank().hasSolventFluid()) {
                solv = TextFormatting.WHITE + this.tile.getIntank().getSolventFluid().getLocalizedName() + ": " + TextFormatting.AQUA + this.tile.getCalculatedYeld() + " mB";
            }
            multistring = new String[]{commDescr, solv};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)130, (int)60, (int)16, (int)31, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            solv = TextFormatting.RED + "N/A";
            commDescr = TextFormatting.GRAY + "Secondary Solvent:";
            if (this.tile.hasIntank() && this.tile.getIntank().hasReagentFluid()) {
                solv = TextFormatting.WHITE + this.tile.getIntank().getReagentFluid().getLocalizedName() + ": " + TextFormatting.AQUA + this.tile.getCalculatedYeld() + " mB";
            }
            multistring = new String[]{commDescr, solv};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)67, (int)51, (int)42, (int)36, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            volt = "Empty Tank";
            if (this.tile.isValidRecipe()) {
                volt = "Valid Recipe";
            }
            tooltip = GuiUtils.drawLabel((String)volt, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)152, (int)94, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y) && this.tile.speedSlot().func_190926_b()) {
            tooltip = GuiUtils.drawLabel((String)this.speed_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)12, (int)25, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            volt = "Voltage not required";
            if (this.tile.hasVoltage()) {
                volt = "Voltage required";
            }
            tooltip = GuiUtils.drawLabel((String)volt, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isValidRecipe()) {
            this.func_73729_b(i + 67, j + 51, 176, 47, 42, 36);
        }
        if (this.tile.getCooktime() > 0) {
            int k = GuiUtils.getScaledValue((int)30, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 25, j + 102, 176, 95, k, 5);
        }
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (this.tile.hasVoltage()) {
            this.func_73729_b(i + 12, j + 25, 176, 29, 14, 14);
        }
    }
}

