/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.machines.container.COExtractorController;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEExtractorController;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIExtractorController
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guiextractorcontroller.png");
    public static ResourceLocation TEXTURE_JEI = new ResourceLocation("rockhounding_chemistry:textures/gui/jei/guichemicalextractorjei.png");
    private final TEExtractorController tile;

    public UIExtractorController(InventoryPlayer playerInv, TEExtractorController tile) {
        super(new COExtractorController((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEExtractorController.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        List tooltip;
        String[] multistring;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        String commDescr = "";
        String commValue = TextFormatting.GRAY + "Reaction Intensity: " + TextFormatting.GREEN + this.tile.getIntensity() + "/16";
        if (GuiUtils.hoveringArea((int)26, (int)97, (int)15, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Current reaction intensity";
            multistring = new String[]{commDescr, commValue};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)10, (int)97, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Decrease reaction intensity";
            multistring = new String[]{commDescr, commValue};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)41, (int)97, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Increase reaction intensity";
            multistring = new String[]{commDescr, commValue};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)115, (int)91, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String rf = TextFormatting.GRAY + "Energy: " + TextFormatting.RED + this.tile.powerConsume() + " RF/t";
            String tk = TextFormatting.GRAY + "Process: " + TextFormatting.YELLOW + this.tile.getCooktimeMax() + " ticks";
            String sf = TextFormatting.GRAY + "Tier: " + TextFormatting.AQUA + this.tile.speedFactor() + "x";
            multistring = new String[]{sf, tk, rf};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)14, (int)34, (int)16, (int)31, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String nitrCons = TextFormatting.RED + "N/A: " + this.tile.calculatedNitr() + " mB";
            commDescr = TextFormatting.GRAY + "Left Channel:";
            if (this.tile.hasIntank() && this.tile.getIntank().hasSolventFluid()) {
                nitrCons = TextFormatting.WHITE + this.tile.getIntank().getSolventFluid().getLocalizedName() + ": " + TextFormatting.AQUA + this.tile.calculatedNitr() + " mB";
            }
            multistring = new String[]{commDescr, nitrCons};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)37, (int)34, (int)16, (int)31, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String cyanCons = TextFormatting.RED + "N/A: " + this.tile.calculatedCyan() + " mB";
            commDescr = TextFormatting.GRAY + "Right Channel:";
            if (this.tile.hasIntank() && this.tile.getIntank().hasReagentFluid()) {
                cyanCons = TextFormatting.WHITE + this.tile.getIntank().getReagentFluid().getLocalizedName() + ": " + TextFormatting.AQUA + this.tile.calculatedCyan() + " mB";
            }
            multistring = new String[]{commDescr, cyanCons};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)114, (int)25, (int)19, (int)19, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String recoveryB = TextFormatting.GRAY + "Safe Recovery: " + TextFormatting.DARK_GREEN + this.tile.baseRecovery() + "%";
            String recoveryR = TextFormatting.GRAY + "Recovery Efficiency: " + TextFormatting.GREEN + this.tile.normalRecovery() + "%";
            String recoveryD = TextFormatting.GRAY + "Dissolution Chance: " + TextFormatting.GOLD + this.tile.dissolutionChance() + "%";
            String recoveryF = TextFormatting.GRAY + "Stabilization: " + TextFormatting.YELLOW + this.tile.recoveryFactor() + "%";
            multistring = new String[]{recoveryB, " ", recoveryR, recoveryD, recoveryF};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)120, (int)62, (int)12, (int)22, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Ingredients recycling", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(String.valueOf(this.tile.getIntensity()), 28, 102, 0x404040);
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (this.tile.getCooktime() > 0) {
            int k = GuiUtils.getScaledValue((int)29, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 70, j + 49, 176, 27, 36, 29 - k);
        } else {
            this.func_73729_b(i + 70, j + 49, 176, 27, 36, 29);
        }
    }
}

