/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.handlers.Reference;
import com.globbypotato.rockhounding_chemistry.machines.GaslineDuct;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGaslinePump;
import com.globbypotato.rockhounding_core.machines.PipelineBase;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GaslinePump
extends PipelineBase {
    ItemStack compressor = new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.COMPRESSOR.ordinal());

    public GaslinePump(String name) {
        super("rockhounding_chemistry", name);
        this.func_149647_a(Reference.RockhoundingChemistry);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PLUG_AABB;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEGaslinePump();
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, BlockPos sidePos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(sidePos);
        Block block = state.func_177230_c();
        return block instanceof GaslineDuct || this.isOrientedVessel(worldIn, sidePos, facing.func_176734_d()) || this.isOrientedVessel(worldIn, sidePos, facing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEGaslinePump pump = (TEGaslinePump)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            if (!world.field_72995_K && player.func_184614_ca().func_190926_b()) {
                pump.activation = !pump.activation;
            }
        } else if (!world.field_72995_K) {
            if (pump.hasUpgrade() && CoreUtils.hasWrench((EntityPlayer)player)) {
                pump.upgrade = false;
                EntityItem upgrade = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.compressor);
                world.func_72838_d((Entity)upgrade);
            }
            if (!pump.hasUpgrade() && CoreUtils.hasTool((EntityPlayer)player, (ItemStack)this.compressor)) {
                pump.upgrade = true;
                pump.markDirtyClient();
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184614_ca().func_190918_g(1);
                }
            }
        }
        world.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile instanceof TEGaslinePump) {
            TEGaslinePump pump = (TEGaslinePump)tile;
            if (CoreUtils.hasWrench((EntityPlayer)playerIn)) {
                if (!playerIn.func_70093_af()) {
                    if (!worldIn.field_72995_K) {
                        ++pump.delay;
                    }
                } else if (!worldIn.field_72995_K && pump.getDelay() > 0) {
                    --pump.delay;
                }
            }
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack itemstack = new ItemStack(Item.func_150898_a((Block)this));
        if (te != null && te instanceof TEGaslinePump) {
            GaslinePump.addNbt(itemstack, te);
        }
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            GaslinePump.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    private static void addNbt(ItemStack itemstack, TileEntity tileentity) {
        TEGaslinePump tile = (TEGaslinePump)tileentity;
        itemstack.func_77982_d(new NBTTagCompound());
        itemstack.func_77978_p().func_74757_a("Upgrade", tile.hasUpgrade());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TEGaslinePump) {
            TEGaslinePump te = (TEGaslinePump)worldIn.func_175625_s(pos);
            if (stack.func_77942_o() && te != null && stack.func_77978_p().func_74764_b("Upgrade")) {
                boolean upg;
                te.upgrade = upg = stack.func_77978_p().func_74767_n("Upgrade");
            }
        }
    }
}

