/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.jei.deposition_chamber;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.compat.jei.RHRecipeWrapper;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.DepositionChamberRecipe;
import com.google.common.base.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class DepositionChamberWrapper
extends RHRecipeWrapper<DepositionChamberRecipe> {
    public DepositionChamberWrapper(@Nonnull DepositionChamberRecipe recipe) {
        super(recipe);
    }

    public static List<DepositionChamberWrapper> getRecipes() {
        ArrayList<DepositionChamberWrapper> recipes = new ArrayList<DepositionChamberWrapper>();
        for (DepositionChamberRecipe recipe : DepositionChamberRecipes.deposition_chamber_recipes) {
            if (!DepositionChamberWrapper.isValidRecipe(recipe)) continue;
            recipes.add(new DepositionChamberWrapper(recipe));
        }
        return recipes;
    }

    private static boolean isValidRecipe(DepositionChamberRecipe recipe) {
        return (!recipe.getType() && !recipe.getInput().func_190926_b() || recipe.getType() && OreDictionary.getOres((String)recipe.getOredict()).size() > 0) && recipe.getSolvent() != null && !recipe.getOutput().func_190926_b();
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (((DepositionChamberRecipe)this.getRecipe()).getType()) {
            inputs.addAll((Collection<ItemStack>)OreDictionary.getOres((String)((DepositionChamberRecipe)this.getRecipe()).getOredict()));
        } else {
            inputs.add(((DepositionChamberRecipe)this.getRecipe()).getInput());
        }
        return inputs;
    }

    public List<ItemStack> getOutputs() {
        return Collections.singletonList(((DepositionChamberRecipe)this.getRecipe()).getOutput());
    }

    @Nonnull
    public List<FluidStack> getSolvents() {
        return Collections.singletonList(((DepositionChamberRecipe)this.getRecipe()).getSolvent());
    }

    @Nonnull
    public List<FluidStack> getCarriers() {
        return Collections.singletonList(((DepositionChamberRecipe)this.getRecipe()).getCarrier());
    }

    @Nonnull
    public List<Integer> getTemperatures() {
        return Collections.singletonList(((DepositionChamberRecipe)this.getRecipe()).getTemperature());
    }

    @Nonnull
    public List<Integer> getPressures() {
        return Collections.singletonList(((DepositionChamberRecipe)this.getRecipe()).getPressure());
    }

    public List<ItemStack> getUtils() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        stacks.add(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.DEPOSITION_CASING.ordinal()));
        stacks.add(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.DEPOSITION_INSULATION.ordinal()));
        return stacks;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String tempString = "N/A";
        if (((DepositionChamberRecipe)this.getRecipe()).getTemperature() > 0) {
            tempString = String.valueOf(((DepositionChamberRecipe)this.getRecipe()).getTemperature()) + "K";
        }
        String pressString = "N/A";
        if (((DepositionChamberRecipe)this.getRecipe()).getPressure() > 0) {
            pressString = String.valueOf(((DepositionChamberRecipe)this.getRecipe()).getPressure()) + "uP";
        }
        String altString = "N/A";
        altString = !Strings.isNullOrEmpty((String)((DepositionChamberRecipe)this.getRecipe()).getRecipeName()) ? ((DepositionChamberRecipe)this.getRecipe()).getRecipeName() : ((DepositionChamberRecipe)this.getRecipe()).getOutput().func_82833_r();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        minecraft.field_71466_p.func_78276_b(altString, 0, 170, Color.red.getRGB());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        minecraft.field_71466_p.func_78276_b(tempString, 0, 147, Color.blue.getRGB());
        minecraft.field_71466_p.func_78276_b(pressString, 247, 147, Color.blue.getRGB());
        GlStateManager.func_179121_F();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(this.getInputs(), this.getUtils()));
        ingredients.setInputLists(VanillaTypes.FLUID, Arrays.asList(this.getSolvents(), this.getCarriers()));
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
    }
}

