/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.SlurryDrumRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.SlurryDrumRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.SlurryDrum")
public class CT_SlurryDrum
extends CTSupport {
    public static String name = "Slurry Drum";
    public static ArrayList<SlurryDrumRecipe> recipeList = SlurryDrumRecipes.slurry_drum_recipes;

    @ZenMethod
    public static void add(IItemStack input, ILiquidStack output) {
        if (input == null || output == null) {
            CT_SlurryDrum.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new SlurryDrumRecipe(CT_SlurryDrum.toStack(input), CT_SlurryDrum.toFluid(output))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_SlurryDrum.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_SlurryDrum.toStack(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_SlurryDrum.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_SlurryDrum.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (SlurryDrumRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (SlurryDrumRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final SlurryDrumRecipe recipe;

        public Add(SlurryDrumRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

