/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PrecipitationRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.Precipitator")
public class CT_Precipitator
extends CTSupport {
    public static String name = "Precipitation Chamber";
    public static ArrayList<PrecipitationRecipe> recipeList = PrecipitationRecipes.precipitation_recipes;

    @ZenMethod
    public static void add(String recipename, IItemStack input, IItemStack catalyst, ILiquidStack solvent, ILiquidStack solution, IItemStack byproduct) {
        if (input == null && catalyst == null || catalyst != null && !CT_Precipitator.toStack(catalyst).func_77973_b().func_77645_m() || solvent == null || solution == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PrecipitationRecipe(recipename, CT_Precipitator.toStack(input), CT_Precipitator.toStack(catalyst), CT_Precipitator.toFluid(solvent), CT_Precipitator.toFluid(solution), CT_Precipitator.toStack(byproduct))));
    }

    @ZenMethod
    public static void add(String recipename, String input, IItemStack catalyst, ILiquidStack solvent, ILiquidStack solution, IItemStack byproduct) {
        if (input == null && catalyst == null || catalyst != null && !CT_Precipitator.toStack(catalyst).func_77973_b().func_77645_m() || solvent == null || solution == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PrecipitationRecipe(recipename, input, CT_Precipitator.toStack(catalyst), CT_Precipitator.toFluid(solvent), CT_Precipitator.toFluid(solution), CT_Precipitator.toStack(byproduct))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_Precipitator.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_Precipitator.toFluid(output)));
    }

    @ZenMethod
    public static void removeByPrecipitate(IItemStack precipitate) {
        if (precipitate == null) {
            CT_Precipitator.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_Precipitator.toStack(precipitate)));
    }

    private static class RemoveByPrecipitate
    implements IAction {
        private ItemStack input;

        public RemoveByPrecipitate(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (PrecipitationRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || !recipe.getSolute().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (PrecipitationRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getSolution().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (PrecipitationRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (PrecipitationRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getSolute().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final PrecipitationRecipe recipe;

        public Add(PrecipitationRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

