/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PollutantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PollutantFluidRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.PollutantFluids")
public class CT_PollutantFluids
extends CTSupport {
    public static String name = "Pollutant Fluids";
    public static ArrayList<FluidStack> pollutantList = PollutantRecipes.pollutant_fluids;
    public static ArrayList<PollutantFluidRecipe> recipeList = PollutantRecipes.pollutant_fluid_recipes;

    @ZenMethod
    public static void pollute(ILiquidStack fluid) {
        if (fluid == null || CT_PollutantFluids.toFluid(fluid).getFluid().isGaseous()) {
            CT_PollutantFluids.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new DeclarePollutant(CT_PollutantFluids.toFluid(fluid)));
    }

    private static class DeclarePollutant
    implements IAction {
        FluidStack input;

        public DeclarePollutant(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            if (!pollutantList.contains(this.input)) {
                pollutantList.add(this.input);
                recipeList.add(new PollutantFluidRecipe(this.input));
            }
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

