/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MineralSizerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MineralSizerRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.MineralSizer")
public class CT_MineralSizer
extends CTSupport {
    public static String name = "Mineral Sizer";
    public static ArrayList<MineralSizerRecipe> recipeList = MineralSizerRecipes.mineral_sizer_recipes;

    @ZenMethod
    public static void add(IItemStack input, IItemStack[] output, int[] comminution) {
        if (input == null || output == null) {
            CT_MineralSizer.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Integer> comminutions = new ArrayList<Integer>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(CT_MineralSizer.toStack(output[x]));
            comminutions.add(comminution[x]);
        }
        CraftTweakerAPI.apply((IAction)new Add(new MineralSizerRecipe(CT_MineralSizer.toStack(input), outputs, comminutions)));
    }

    @ZenMethod
    public static void add(IItemStack input, IItemStack output) {
        if (input == null || output == null) {
            CT_MineralSizer.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Integer> comminutions = new ArrayList<Integer>();
        outputs.add(CT_MineralSizer.toStack(output));
        comminutions.add(0);
        CraftTweakerAPI.apply((IAction)new Add(new MineralSizerRecipe(CT_MineralSizer.toStack(input), outputs, comminutions)));
    }

    @ZenMethod
    public static void add(String input, IItemStack[] output, int[] comminution) {
        if (input == null || output == null) {
            CT_MineralSizer.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Integer> comminutions = new ArrayList<Integer>();
        for (int x = 0; x < output.length; ++x) {
            outputs.add(CT_MineralSizer.toStack(output[x]));
            comminutions.add(comminution[x]);
        }
        CraftTweakerAPI.apply((IAction)new Add(new MineralSizerRecipe(input, outputs, comminutions)));
    }

    @ZenMethod
    public static void add(String input, IItemStack output) {
        if (input == null || output == null) {
            CT_MineralSizer.error(name);
            return;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Integer> comminutions = new ArrayList<Integer>();
        outputs.add(CT_MineralSizer.toStack(output));
        comminutions.add(0);
        CraftTweakerAPI.apply((IAction)new Add(new MineralSizerRecipe(input, outputs, comminutions)));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        if (input == null) {
            CT_MineralSizer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_MineralSizer.toStack(input)));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_MineralSizer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_MineralSizer.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_MineralSizer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (MineralSizerRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Remove
    implements IAction {
        private ItemStack input;

        public Remove(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (MineralSizerRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final MineralSizerRecipe recipe;

        public Add(MineralSizerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

