/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasifierPlantRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasifierPlantRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.GasifierPlant")
public class CT_GasifierPlant
extends CTSupport {
    public static String name = "Gasification Plant";
    public static ArrayList<GasifierPlantRecipe> recipeList = GasifierPlantRecipes.gasifier_plant_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, ILiquidStack reactant, ILiquidStack output, IItemStack slag1, IItemStack slag2, int temperature) {
        if (input == null || reactant == null || output == null || !CT_GasifierPlant.toFluid(output).getFluid().isGaseous()) {
            CT_GasifierPlant.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new GasifierPlantRecipe(CT_GasifierPlant.toFluid(input), CT_GasifierPlant.toFluid(reactant), CT_GasifierPlant.toFluid(output), CT_GasifierPlant.toStack(slag1), CT_GasifierPlant.toStack(slag2), temperature)));
    }

    @ZenMethod
    public static void removeByInput(ILiquidStack input) {
        if (input == null) {
            CT_GasifierPlant.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_GasifierPlant.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_GasifierPlant.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_GasifierPlant.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (GasifierPlantRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private FluidStack input;

        public RemoveByInput(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (GasifierPlantRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final GasifierPlantRecipe recipe;

        public Add(GasifierPlantRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

