/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasPurifierRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasPurifierRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.GasPurifier")
public class CT_GasPurifier
extends CTSupport {
    public static String name = "Gas Purifier";
    public static ArrayList<GasPurifierRecipe> recipeList = GasPurifierRecipes.gas_purifier_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, ILiquidStack output, IItemStack slag1, IItemStack slag2) {
        if (input == null || output == null || !CT_GasPurifier.toFluid(input).getFluid().isGaseous() || !CT_GasPurifier.toFluid(output).getFluid().isGaseous()) {
            CT_GasPurifier.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new GasPurifierRecipe(CT_GasPurifier.toFluid(input), CT_GasPurifier.toFluid(output), CT_GasPurifier.toStack(slag1), CT_GasPurifier.toStack(slag2))));
    }

    @ZenMethod
    public static void removeByInput(ILiquidStack input) {
        if (input == null) {
            CT_GasPurifier.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_GasPurifier.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_GasPurifier.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_GasPurifier.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (GasPurifierRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private FluidStack input;

        public RemoveByInput(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (GasPurifierRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final GasPurifierRecipe recipe;

        public Add(GasPurifierRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

