/*
 * Decompiled with CFR 0.152.
 */
package nex.world.biome;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lex.config.Config;
import lex.world.biome.BiomeWrapper;
import lex.world.gen.GenerationStage;
import lex.world.gen.feature.Feature;
import lex.world.gen.feature.FeatureRegistry;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeWrapperNetherEx
extends BiomeWrapper {
    public BiomeWrapperNetherEx(Config configIn) {
        super(configIn);
    }

    protected void parse() {
        this.biome = (Biome)ForgeRegistries.BIOMES.getValue(this.config.getResource("biome"));
        if (this.biome != null) {
            ResourceLocation biomeName = this.biome.getRegistryName();
            this.weight = this.config.getInt("weight", 10);
            if (!biomeName.func_110624_b().equalsIgnoreCase("biomesoplenty")) {
                Config blockConfig = this.config.getDataBranch("blocks", new JsonObject());
                blockConfig.getBlock("topBlock", this.biome.field_76752_A);
                blockConfig.getBlock("fillerBlock", this.biome.field_76753_B);
                for (Map.Entry entry : blockConfig.getAllData().entrySet()) {
                    if (blockConfig.getBlock((String)entry.getKey()) == null) continue;
                    this.blocks.put(entry.getKey(), blockConfig.getBlock((String)entry.getKey()));
                }
            }
            List entityConfigs = this.config.getDataBranches("entities", new ArrayList());
            ArrayList<JsonObject> entityObjects = new ArrayList<JsonObject>();
            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                block2: for (Biome.SpawnListEntry entry : this.biome.func_76747_a(creatureType)) {
                    ResourceLocation entityName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityRegistry.getEntry((Class)entry.field_76300_b));
                    boolean containsEntry = false;
                    Iterator configIter = entityConfigs.iterator();
                    while (configIter.hasNext()) {
                        Config entityConfig = (Config)configIter.next();
                        if (entityName != null && entityConfig.getString("entity").equals(entityName.toString())) {
                            containsEntry = true;
                        }
                        entityObjects.add(entityConfig.serialize().getAsJsonObject());
                        configIter.remove();
                        if (!containsEntry) continue;
                        continue block2;
                    }
                    JsonObject entityObject = new JsonObject();
                    entityObject.addProperty("entity", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityRegistry.getEntry((Class)entry.field_76300_b)).toString());
                    entityObject.addProperty("creatureType", creatureType.toString().toLowerCase());
                    entityObject.addProperty("weight", (Number)entry.field_76292_a);
                    entityObject.addProperty("minGroupCount", (Number)entry.field_76301_c);
                    entityObject.addProperty("maxGroupCount", (Number)entry.field_76299_d);
                    entityObject.addProperty("spawn", Boolean.valueOf(true));
                    entityObjects.add(entityObject);
                }
            }
            this.config.removeData("entities");
            entityConfigs = this.config.getDataBranches("entities", entityObjects);
            for (Config entityConfig : entityConfigs) {
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityConfig.getResource("entity"));
                if (entry == null || !entityConfig.getBoolean("spawn", true)) continue;
                Class entityCls = entry.getEntityClass();
                EnumCreatureType creatureType = (EnumCreatureType)entityConfig.getEnum("creatureType", EnumCreatureType.class);
                if (!EntityLiving.class.isAssignableFrom(entityCls)) continue;
                this.spawnableMobs.computeIfAbsent(creatureType, k -> new ArrayList()).add(new Biome.SpawnListEntry(entityCls, entityConfig.getInt("weight", 10), entityConfig.getInt("minGroupCount", 1), entityConfig.getInt("maxGroupCount", 4)));
            }
            List list = this.config.getDataBranches("features", new ArrayList());
            ArrayList<JsonObject> featureObjects = new ArrayList<JsonObject>();
            for (Config featureConfig : list) {
                Feature feature = FeatureRegistry.createFeature((ResourceLocation)featureConfig.getResource("feature"), (Config)featureConfig);
                if (feature != null && featureConfig.getBoolean("generate", true)) {
                    GenerationStage generationStage = (GenerationStage)featureConfig.getEnum("genStage", GenerationStage.class, (Enum)GenerationStage.POST_DECORATE);
                    this.generationStageFeatures.computeIfAbsent(generationStage, k -> new ArrayList()).add(feature);
                }
                featureObjects.add(featureConfig.serialize().getAsJsonObject());
            }
            this.config.removeData("features");
            this.config.getDataBranches("features", featureObjects);
            this.enabled = this.config.getBoolean("enabled", true);
            this.genDefaultFeatures = this.config.getBoolean("genDefaultFeatures", true);
        }
    }
}

