/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lex.util.WeightedHelper;
import lex.village.Trade;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import nex.init.NetherExLootTables;
import nex.init.NetherExTextures;

public class Pigtificate {

    public static enum Career {
        CHIEF(Profession.LEADER, 16, NetherExTextures.PIGTIFICATE_CHIEF, NetherExLootTables.PIGTIFICATE_CHIEF),
        HUNTER(Profession.FORAGER, 5, NetherExTextures.PIGTIFICATE_HUNTER, NetherExLootTables.PIGTIFICATE_HUNTER),
        GATHERER(Profession.FORAGER, 5, NetherExTextures.PIGTIFICATE_GATHERER, NetherExLootTables.PIGTIFICATE_GATHERER),
        SCAVENGER(Profession.FORAGER, 5, NetherExTextures.PIGTIFICATE_SCAVENGER, NetherExLootTables.PIGTIFICATE_SCAVENGER),
        ARMORSMITH(Profession.BLACKSMITH, 8, NetherExTextures.PIGTIFICATE_ARMORSMITH, NetherExLootTables.PIGTIFICATE_ARMORSMITH),
        TOOLSMITH(Profession.BLACKSMITH, 8, NetherExTextures.PIGTIFICATE_TOOLSMITH, NetherExLootTables.PIGTIFICATE_TOOLSMITH),
        ENCHANTER(Profession.SORCERER, 8, NetherExTextures.PIGTIFICATE_ENCHANTER, NetherExLootTables.PIGTIFICATE_ENCHANTER),
        BREWER(Profession.SORCERER, 8, NetherExTextures.PIGTIFICATE_BREWER, NetherExLootTables.PIGTIFICATE_BREWER);

        private Profession profession;
        private int weight;
        private ResourceLocation texture;
        private ResourceLocation lootTable;
        private final Map<Integer, List<Trade>> trades = new HashMap<Integer, List<Trade>>();

        private Career(Profession profession, int weight, ResourceLocation texture, ResourceLocation lootTable) {
            this.profession = profession;
            this.weight = weight;
            this.texture = texture;
            this.lootTable = lootTable;
        }

        public void addTrade(Trade trade) {
            this.trades.computeIfAbsent(trade.getTradeLevel(), k -> new ArrayList()).add(trade);
        }

        public void removeAllTrades() {
            this.trades.clear();
        }

        public static Career getFromIndex(int index) {
            Career career = Career.values()[index];
            return career != null ? career : HUNTER;
        }

        public static Career getFromString(String string) {
            if (!Strings.isNullOrEmpty((String)string)) {
                for (Career career : Career.values()) {
                    if (!career.name().equalsIgnoreCase(string)) continue;
                    return career;
                }
            }
            return HUNTER;
        }

        public static Career getRandom(Profession profession, Random rand) {
            ArrayList<WeightedHelper.NamedItem> careers = new ArrayList<WeightedHelper.NamedItem>();
            for (Career career : Career.values()) {
                if (profession != career.getProfession()) continue;
                careers.add(new WeightedHelper.NamedItem(career.name(), career.getWeight()));
            }
            return Career.getFromString(((WeightedHelper.NamedItem)WeightedRandom.func_76271_a((Random)rand, careers)).getName());
        }

        public int getWeight() {
            return this.weight;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        public Profession getProfession() {
            return this.profession;
        }

        public Map<Integer, List<Trade>> getTrades() {
            return ImmutableMap.copyOf(this.trades);
        }
    }

    public static enum Profession {
        LEADER,
        FORAGER,
        BLACKSMITH,
        SORCERER;


        public static Profession getRandom(Random rand, boolean isLeader) {
            if (isLeader) {
                return LEADER;
            }
            ArrayList types = new ArrayList();
            Collections.addAll(types, Profession.values());
            types.remove((Object)LEADER);
            return (Profession)((Object)types.get(rand.nextInt(types.size())));
        }

        public static Profession getFromIndex(int index) {
            Profession profession = Profession.values()[index];
            return profession != null ? profession : FORAGER;
        }

        public static Profession getFromString(String string) {
            if (!Strings.isNullOrEmpty((String)string)) {
                for (Profession profession : Profession.values()) {
                    if (!profession.name().equalsIgnoreCase(string)) continue;
                    return profession;
                }
            }
            return FORAGER;
        }
    }
}

