/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.ai;

import lex.util.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nex.village.PigtificateVillage;
import nex.village.PigtificateVillageFenceGateInfo;
import nex.village.PigtificateVillageManager;

public class EntityAIRestrictFenceGateUse
extends EntityAIBase {
    private final EntityCreature creature;
    private PigtificateVillageFenceGateInfo fenceGate;

    public EntityAIRestrictFenceGateUse(EntityCreature creature) {
        this.creature = creature;
        if (!(creature.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for EntityAIRestrictFenceGateUse");
        }
    }

    public boolean func_75250_a() {
        World world = this.creature.func_130014_f_();
        if (WorldHelper.isDaytime((World)world)) {
            return false;
        }
        BlockPos pos = new BlockPos((Entity)this.creature);
        PigtificateVillage village = PigtificateVillageManager.getVillageData(world, true).getNearestVillage(pos, 16);
        if (village == null) {
            return false;
        }
        this.fenceGate = village.getNearestFenceGate(pos);
        return this.fenceGate != null && (double)this.fenceGate.getDistanceToInsideBlockSq(pos) < 2.25;
    }

    public boolean func_75253_b() {
        return !WorldHelper.isDaytime((World)this.creature.func_130014_f_()) && !this.fenceGate.isDetachedFromVillageFlag() && this.fenceGate.isInside(new BlockPos((Entity)this.creature));
    }

    public void func_75249_e() {
        ((PathNavigateGround)this.creature.func_70661_as()).func_179688_b(false);
        ((PathNavigateGround)this.creature.func_70661_as()).func_179691_c(false);
    }

    public void func_75251_c() {
        ((PathNavigateGround)this.creature.func_70661_as()).func_179688_b(true);
        ((PathNavigateGround)this.creature.func_70661_as()).func_179691_c(true);
        this.fenceGate = null;
    }

    public void func_75246_d() {
        this.fenceGate.incrementOpenRestrictionCounter();
    }
}

