/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.village;

import fathertoast.specialai.config.Config;
import fathertoast.specialai.util.NameHelperVillager;
import fathertoast.specialai.village.MessageReputationFX;
import fathertoast.specialai.village.VillageCollectionSafe;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ReputationHandler {
    public static final int REPUTATION_HATED = -15;

    static void addReputation(EntityPlayer player, BlockPos sourcePos, Village village, int rep) {
        if (rep != 0) {
            village.modifyPlayerReputation(player.func_110124_au(), rep);
            ReputationHandler.playReputationEffects(player.field_70170_p, sourcePos, rep > 0);
        }
    }

    static void playReputationEffects(World world, BlockPos sourcePos, boolean happy) {
        if (Config.get().VILLAGES.REPUTATION_PARTICLES) {
            if (happy) {
                MessageReputationFX.Type.HAPPY.send(world, sourcePos);
            } else {
                MessageReputationFX.Type.ANGRY.send(world, sourcePos);
            }
        }
        if (Config.get().VILLAGES.REPUTATION_SOUNDS) {
            world.func_184133_a(null, sourcePos, happy ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm, SoundCategory.PLAYERS, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    static void playAggroEffects(World world, BlockPos sourcePos) {
        if (Config.get().VILLAGES.REPUTATION_PARTICLES) {
            world.func_175718_b(2004, sourcePos, 0);
        }
        if (Config.get().VILLAGES.REPUTATION_SOUNDS) {
            world.func_184133_a(null, sourcePos, SoundEvents.field_187912_gl, SoundCategory.PLAYERS, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
        }
    }

    static void addReputationToAll(World world, double radius, Village village, int rep) {
        double maxDist = (double)village.func_75568_b() + radius;
        BlockPos coords = village.func_180608_a();
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player.func_174818_b(coords) <= maxDist * maxDist)) continue;
            village.modifyPlayerReputation(player.func_110124_au(), 0);
        }
        village.func_82683_b(rep);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            if (Config.get().VILLAGES.NAME_VILLAGERS && !villager.func_145818_k_()) {
                NameHelperVillager.setVillagerName(villager.func_70681_au(), villager);
            }
            if (Config.get().VILLAGES.NAME_VILLAGERS_ALWAYS_SHOW && villager.func_145818_k_()) {
                villager.func_174805_g(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72982_D != null && !VillageCollectionSafe.class.equals(event.getWorld().field_72982_D.getClass())) {
            String dataIdentifier = VillageCollection.func_176062_a((WorldProvider)event.getWorld().field_73011_w);
            VillageCollectionSafe newVillageCollection = null;
            try {
                File villagesdat = event.getWorld().func_72860_G().func_75758_b(dataIdentifier);
                if (villagesdat.exists()) {
                    newVillageCollection = new VillageCollectionSafe(dataIdentifier);
                    newVillageCollection.func_82566_a(event.getWorld());
                    FileInputStream in = new FileInputStream(villagesdat);
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)in);
                    in.close();
                    newVillageCollection.func_76184_a(tag.func_74775_l("data"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (newVillageCollection == null) {
                newVillageCollection = new VillageCollectionSafe(event.getWorld());
            }
            event.getWorld().field_72982_D = newVillageCollection;
            event.getWorld().getPerWorldStorage().func_75745_a(dataIdentifier, (WorldSavedData)event.getWorld().field_72982_D);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        Village village;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (Config.get().VILLAGES.HELP_REP_CHANCE > 0.0 && event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false) && event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntityLiving().func_70681_au().nextDouble() < Config.get().VILLAGES.HELP_REP_CHANCE && (village = event.getEntityLiving().field_70170_p.field_72982_D.func_176056_a(new BlockPos((Entity)event.getEntityLiving()), 32)) != null) {
            ReputationHandler.addReputation((EntityPlayer)event.getSource().func_76346_g(), new BlockPos((Entity)event.getEntityLiving()), village, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            this.onBlockBreak(new BlockEvent.BreakEvent(event.getWorld(), event.getPos(), event.getState(), (EntityPlayer)event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean trigger;
        if (event.getWorld().field_72995_K || event.getPlayer() == null) {
            return;
        }
        Village village = event.getWorld().field_72982_D.func_176056_a(event.getPos(), 8);
        if (village == null) {
            return;
        }
        boolean isTreasure = Config.get().VILLAGES.TREASURED_LIST.matches(event.getState());
        if (!isTreasure && (!Config.get().VILLAGES.BLOCK_WHITELIST.isEmpty() && !Config.get().VILLAGES.BLOCK_WHITELIST.matches(event.getState()) || Config.get().VILLAGES.BLOCK_BLACKLIST.matches(event.getState()))) {
            return;
        }
        int playerRep = village.getPlayerReputation(event.getPlayer().func_110124_au());
        if (playerRep <= Config.get().VILLAGES.BLOCK_REP_LIMIT) {
            if (isTreasure) {
                trigger = event.getWorld().field_73012_v.nextDouble() < Config.get().VILLAGES.TREASURED_REP_CHANCE;
            } else {
                boolean bl = trigger = event.getWorld().field_73012_v.nextDouble() < Config.get().VILLAGES.BLOCK_REP_CHANCE;
            }
            if (trigger) {
                ReputationHandler.addReputation(event.getPlayer(), event.getPos(), village, -1);
            }
        }
        if (playerRep <= -15) {
            village.func_75575_a((EntityLivingBase)event.getPlayer());
            ReputationHandler.playAggroEffects(event.getWorld(), event.getPos());
        } else if (playerRep <= Config.get().VILLAGES.BLOCK_ATTACK_LIMIT) {
            if (isTreasure) {
                trigger = event.getWorld().field_73012_v.nextDouble() < Config.get().VILLAGES.TREASURED_ATTACK_CHANCE;
            } else {
                boolean bl = trigger = event.getWorld().field_73012_v.nextDouble() < Config.get().VILLAGES.BLOCK_ATTACK_CHANCE;
            }
            if (trigger) {
                village.func_75575_a((EntityLivingBase)event.getPlayer());
                ReputationHandler.playAggroEffects(event.getWorld(), event.getPos());
            }
        }
    }
}

