/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai.elite;

import fathertoast.specialai.ai.elite.IEliteAI;
import fathertoast.specialai.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;

public class EntityAIShaman
extends EntityAIBase
implements IEliteAI {
    private int WEIGHT;
    protected EntityLiving theEntity;
    private float healAmount;
    private NBTTagList potionEffects;
    private EntityLiving followTarget;
    private int healTime;

    EntityAIShaman() {
    }

    private EntityAIShaman(EntityLiving entity, float healAmount, NBTTagList effects) {
        this.theEntity = entity;
        this.healAmount = healAmount;
        this.potionEffects = effects;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "shaman";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        NBTTagList effects = aiTag.func_74764_b(this.getName() + "FX") ? aiTag.func_150295_c(this.getName() + "FX", (int)new NBTTagCompound().func_74732_a()) : new NBTTagList();
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIShaman(entity, aiTag.func_74760_g(this.getName()), effects));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), Config.get().ELITE_AI.SHAMAN_HEAL_AMOUNT);
        PotionEffect[] fx = new PotionEffect[]{new PotionEffect(MobEffects.field_76420_g, 50, 0), new PotionEffect(MobEffects.field_76429_m, 50, 0), new PotionEffect(MobEffects.field_76424_c, 50, 0)};
        NBTTagList fxTag = new NBTTagList();
        for (PotionEffect effect : fx) {
            fxTag.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
        }
        aiTag.func_74782_a(this.getName() + "FX", (NBTBase)fxTag);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151103_aS));
        entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150428_aP));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Shaman health boost", Config.get().ELITE_AI.SHAMAN_HEALTH_BOOST, 0));
    }

    public boolean func_75250_a() {
        return this.findFollowTarget();
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        return target != null && this.followTarget != null && this.followTarget.func_70089_S() && (target == this.followTarget.func_70638_az() || this.findFollowTarget());
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        double distance = this.theEntity.func_70068_e((Entity)this.followTarget);
        if (distance > 36.0) {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.followTarget, 1.3);
        } else if (distance < 4.0) {
            this.theEntity.func_70661_as().func_75499_g();
        }
        if (this.theEntity.func_70661_as().func_75500_f()) {
            if (target != null) {
                this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            }
        } else {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.followTarget, 30.0f, 30.0f);
        }
        --this.healTime;
        if (this.healTime <= 0) {
            this.healTime = 40;
            List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72321_a(16.0, 8.0, 16.0));
            Collections.shuffle(list);
            for (Object entity : list) {
                EntityLiving healTarget;
                if (!(entity instanceof EntityLiving) || target != (healTarget = (EntityLiving)entity).func_70638_az() || !this.theEntity.func_70635_at().func_75522_a((Entity)healTarget)) continue;
                healTarget.func_70691_i(this.healAmount);
                healTarget.func_70066_B();
                int length = this.potionEffects.func_74745_c();
                for (int i = 0; i < length; ++i) {
                    PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)this.potionEffects.func_150305_b(i));
                    healTarget.func_70690_d(effect);
                }
                this.theEntity.field_70170_p.func_175718_b(2005, new BlockPos((Entity)healTarget), 0);
            }
        }
    }

    private boolean findFollowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target != null) {
            List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72321_a(16.0, 8.0, 16.0));
            Collections.shuffle(list);
            for (Object entity : list) {
                if (!(entity instanceof EntityLiving) || target != ((EntityLiving)entity).func_70638_az()) continue;
                this.followTarget = (EntityLiving)entity;
                return true;
            }
        }
        return false;
    }
}

