/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai;

import fathertoast.specialai.ai.AIHandler;
import fathertoast.specialai.config.Config;
import fathertoast.specialai.village.CommandVillageInfo;
import fathertoast.specialai.village.MessageReputationFX;
import fathertoast.specialai.village.ReputationHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="specialai", name="Special AI", version="1.1.0_for_mc1.12.2", acceptedMinecraftVersions="[1.12.2]")
public class SpecialAIMod {
    public static final String MOD_ID = "specialai";
    public static final String NAME = "Special AI";
    public static final String VERSION = "1.1.0_for_mc1.12.2";
    public static final String BASE_TAG = "sAI";
    private static Logger logger;
    private static SimpleNetworkWrapper networkWrapper;

    public static Logger log() {
        return logger;
    }

    public static SimpleNetworkWrapper network() {
        return networkWrapper;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Config.init(logger, "Special_AI", event.getModConfigurationDirectory());
        int id = -1;
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("SAI|FX");
        if (event.getSide() == Side.CLIENT) {
            SpecialAIMod.network().registerMessage(MessageReputationFX.Handler.class, MessageReputationFX.class, ++id, Side.CLIENT);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.load();
        if (Config.get().GENERAL.DEBUG) {
            SpecialAIMod.log().info("Loaded in debug mode!");
        }
        MinecraftForge.EVENT_BUS.register((Object)new AIHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ReputationHandler());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ServerCommandManager commandManager = (ServerCommandManager)event.getServer().func_71187_D();
        commandManager.func_71560_a((ICommand)new CommandVillageInfo());
    }

    public static NBTTagCompound getTag(Entity entity) {
        NBTTagCompound data = entity.getEntityData();
        if (!data.func_74764_b(BASE_TAG)) {
            data.func_74782_a(BASE_TAG, (NBTBase)new NBTTagCompound());
        }
        return data.func_74775_l(BASE_TAG);
    }
}

