/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.factories;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.item.ItemDrone;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ColorDroneRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapelessOreRecipe recipe = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
        return new ColorDroneRecipe(PneumaticCraftUtils.RL("color_drone"), recipe.func_77571_b(), recipe.func_192400_c().toArray());
    }

    private class ColorDroneRecipe
    extends ShapelessOreRecipe {
        ColorDroneRecipe(ResourceLocation group, ItemStack result, Object ... recipe) {
            super(group, result, recipe);
        }

        public boolean func_77569_a(InventoryCrafting inv, World world) {
            boolean hasDrone = false;
            boolean hasDye = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_77973_b() instanceof ItemDrone) {
                    if (!hasDrone) {
                        hasDrone = true;
                        continue;
                    }
                    return false;
                }
                if (stack.func_190926_b() || DyeUtils.rawDyeDamageFromStack((ItemStack)stack) < 0) continue;
                if (!hasDye) {
                    hasDye = true;
                    continue;
                }
                return false;
            }
            return hasDrone && hasDye;
        }

        @Nonnull
        public ItemStack func_77572_b(InventoryCrafting inv) {
            ItemStack drone = ItemStack.field_190927_a;
            int dyeIndex = -1;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof ItemDrone) {
                    drone = stack.func_77946_l();
                    continue;
                }
                if (dyeIndex != -1) continue;
                dyeIndex = DyeUtils.rawDyeDamageFromStack((ItemStack)stack);
            }
            NBTTagCompound droneTag = drone.func_77978_p();
            if (droneTag == null) {
                droneTag = new NBTTagCompound();
                drone.func_77982_d(droneTag);
            }
            droneTag.func_74768_a("color", ItemDye.field_150922_c[dyeIndex]);
            return drone;
        }
    }
}

