/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class PacketRotateBlock
extends LocationIntPacket<PacketRotateBlock> {
    private EnumFacing side;
    private EnumHand hand;
    private int entityID;

    public PacketRotateBlock() {
    }

    public PacketRotateBlock(BlockPos pos, EnumFacing side, EnumHand hand) {
        super(pos);
        this.side = side;
        this.hand = hand;
        this.entityID = -1;
    }

    public PacketRotateBlock(BlockPos pos, EnumHand hand, int entityID) {
        super(pos);
        this.side = null;
        this.hand = hand;
        this.entityID = entityID;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.hand.ordinal());
        if (this.entityID >= 0) {
            buf.writeBoolean(true);
            buf.writeInt(this.entityID);
        } else {
            buf.writeBoolean(false);
            buf.writeByte(this.side.ordinal());
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.hand = EnumHand.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.entityID = buf.readInt();
            this.side = null;
        } else {
            this.side = EnumFacing.values()[buf.readByte()];
            this.entityID = -1;
        }
    }

    @Override
    public void handleClientSide(PacketRotateBlock message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketRotateBlock message, EntityPlayer player) {
        if (player.field_70170_p.func_175667_e(message.pos) && player.func_174818_b(message.pos) < 64.0 && ModdedWrenchUtils.getInstance().isModdedWrench(player.func_184586_b(message.hand))) {
            IBlockState state;
            if (message.entityID >= 0) {
                Entity e = player.field_70170_p.func_73045_a(message.entityID);
                if (e instanceof IPneumaticWrenchable && e.func_70089_S()) {
                    ((IPneumaticWrenchable)e).rotateBlock(player.field_70170_p, player, message.pos, message.side, message.hand);
                }
            } else if (message.side != null && (state = player.field_70170_p.func_180495_p(message.pos)).func_177230_c() instanceof IPneumaticWrenchable) {
                ((IPneumaticWrenchable)state.func_177230_c()).rotateBlock(player.field_70170_p, player, message.pos, message.side, message.hand);
            }
        }
    }
}

