/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReinforcedAirCanister
extends ItemPneumatic
implements IPressurizable {
    private static final String NBT_AIR = "air";
    private static final int MAX_DAMAGE = 250;

    public ItemReinforcedAirCanister() {
        super("reinforced_air_canister");
        this.func_77625_d(1);
        this.func_77656_e(250);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(tab)) {
            ItemStack stack2 = new ItemStack((Item)this);
            this.addAir(stack2, 120000);
            ItemStack stack = new ItemStack((Item)this);
            this.addAir(stack, 0);
            par3List.add((Object)stack);
            par3List.add((Object)stack2);
        }
    }

    public int getDamage(ItemStack stack) {
        return (int)(250.0f * (this.getPressure(stack) / this.maxPressure(stack)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemPressurizable.shouldShowPressureDurability(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ItemPressurizable.getDurabilityColor(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)(this.getPressure(stack) / this.maxPressure(stack));
    }

    @Override
    public float getPressure(ItemStack iStack) {
        int currentAir = NBTUtil.getInteger(iStack, NBT_AIR);
        return (float)currentAir / (float)this.getVolume(iStack);
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        int currentAir = NBTUtil.getInteger(iStack, NBT_AIR);
        NBTUtil.setInteger(iStack, NBT_AIR, MathHelper.func_76125_a((int)(currentAir + amount), (int)0, (int)120000));
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 20.0f;
    }

    @Override
    public int getVolume(ItemStack iStack) {
        return 6000;
    }
}

