/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class DroneEntityAIInventoryExport
extends DroneAIImExBase {
    public DroneEntityAIInventoryExport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.export(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.export(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean export(BlockPos pos, boolean simulate) {
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (droneStack.func_190926_b()) continue;
                if (this.widget.isItemValidForFilters(droneStack)) {
                    for (int side = 0; side < 6; ++side) {
                        if (!((ISidedWidget)((Object)this.widget)).getSides()[side]) continue;
                        droneStack = droneStack.func_77946_l();
                        int oldCount = droneStack.func_190916_E();
                        if (((ICountWidget)((Object)this.widget)).useCount()) {
                            droneStack.func_190920_e(Math.min(droneStack.func_190916_E(), this.getRemainingCount()));
                        }
                        ItemStack remainder = IOHelper.insert(te, droneStack.func_77946_l(), EnumFacing.func_82600_a((int)side), simulate);
                        int stackSize = this.drone.getInv().getStackInSlot(i).func_190916_E() - (remainder.func_190926_b() ? droneStack.func_190916_E() : droneStack.func_190916_E() - remainder.func_190916_E());
                        droneStack.func_190920_e(stackSize);
                        int exportedItems = oldCount - stackSize;
                        if (!simulate) {
                            this.drone.getInv().setStackInSlot(i, stackSize > 0 ? droneStack : ItemStack.field_190927_a);
                            this.decreaseCount(exportedItems);
                        }
                        if (!simulate || exportedItems <= 0) continue;
                        return true;
                    }
                    if (droneStack.func_190926_b() && !simulate) {
                        this.drone.addAir(null, -10);
                        continue;
                    }
                    this.drone.addDebugEntry("gui.progWidget.inventoryExport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.addDebugEntry("gui.progWidget.inventoryExport.debug.stackdoesntPassFilter", pos);
            }
        } else {
            this.drone.addDebugEntry("gui.progWidget.inventory.debug.noInventory", pos);
        }
        return false;
    }
}

