/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportUtils;
import ovh.corail.tombstone.registry.ModEnchantments;

public class Helper {
    public static final Random random = new Random();
    @Nullable
    public static Boolean isHalloween = null;
    public static boolean isContributor = false;
    public static ContributorStore CONTRIBUTORS = ContributorStore.of();

    public static boolean isContributor(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return isContributor;
        }
        return CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(@Nullable Perk perk) {
        return perk == null || perk.isDisabled();
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !world.func_189509_E(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld() ? Math.max(Math.min(y, ((ICubicWorld)world).getMaxHeight()), ((ICubicWorld)world).getMinHeight()) : Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !world.func_189509_E(pos);
    }

    public static boolean isValidDimension(int dim) {
        return Helper.getDimensionIds().contains(dim);
    }

    private static List<Integer> getDimensionIds() {
        return Arrays.asList(DimensionManager.getStaticDimensionIDs());
    }

    public static List<String> getDimensionIdsAsStringList() {
        return Helper.getDimensionIds().stream().map(Object::toString).collect(Collectors.toList());
    }

    public static Location findNearestStructure(WorldServer world, BlockPos pos, SupportStructures struct, boolean unexplored) {
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 15; ++nbTry) {
            BlockPos foundPos;
            if (nbTry > 3) {
                startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177982_a(Helper.getRandom(-nbTry * 500, nbTry * 500), 0, Helper.getRandom(-nbTry * 500, nbTry * 500)));
            }
            if ((foundPos = world.func_190528_a(struct.getStructureName(), startingPos, unexplored)) == null || !Helper.isValidPos((World)world, foundPos) || !struct.isValidBiome(world.func_180494_b(foundPos).getRegistryName())) continue;
            Location structureLoc = new Location(foundPos, (World)world);
            if (struct == SupportStructures.Village && unexplored && Helper.isVillageExplored((World)world, structureLoc.getPos())) continue;
            return structureLoc;
        }
        return Location.ORIGIN;
    }

    public static boolean isVillageExplored(World world, BlockPos villagePos) {
        return world.func_175714_ae().func_75540_b().stream().anyMatch(v -> v.func_180608_a().equals((Object)villagePos));
    }

    public static Location findSpawnForVillage(WorldServer world, BlockPos villagePos) {
        return new SpawnHelper(world, world.func_175672_r(villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc) {
        return (T)TeleportUtils.teleportEntity(entity, loc.dim, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleportEntity(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(EntityPlayer player) {
        return Helper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_82766_b("keepInventory");
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, IBlockState state) {
        ExtendedBlockStorage storage;
        if (!ConfigTombstone.general.gravesByPassGriefingRules) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        if (SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld()) {
            ICubicWorld cubicWorld = (ICubicWorld)world;
            ICube cube = cubicWorld.getCubeFromBlockCoords(pos);
            storage = cube.getStorage();
            if (storage == null) {
                cube.setLightFor(EnumSkyBlock.BLOCK, pos, cube.getLightFor(EnumSkyBlock.BLOCK, pos));
                storage = cube.getStorage();
            }
        } else {
            Chunk chunk = world.func_175726_f(pos);
            ExtendedBlockStorage[] storageArray = chunk.func_76587_i();
            storage = storageArray[pos.func_177956_o() >> 4];
            if (storage == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
                storageArray[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storage = extendedBlockStorage;
            }
            chunk.func_76630_e();
        }
        IBlockState oldState = storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        if (state.getLightOpacity((IBlockAccess)world, pos) != oldState.getLightOpacity((IBlockAccess)world, pos) || state.getLightValue((IBlockAccess)world, pos) != oldState.getLightValue((IBlockAccess)world, pos)) {
            world.func_175664_x(pos);
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, state, 3);
    }

    public static boolean canShowTooltip() {
        return ConfigTombstone.client.showEnhancedTooltips || GuiScreen.func_146272_n();
    }

    public static boolean isDateAroundHalloween() {
        return isHalloween != null && isHalloween != false;
    }

    public static boolean isDateAroundHalloween(World world) {
        if (isHalloween == null) {
            return Helper.isDateAroundHalloween(world.func_83015_S());
        }
        return isHalloween;
    }

    private static boolean isDateAroundHalloween(Calendar calendar) {
        if (isHalloween == null) {
            isHalloween = ConfigTombstone.general.persistantHalloween || calendar.get(2) + 1 == 10 && calendar.get(5) >= 20 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 3;
        }
        return isHalloween;
    }

    public static boolean isNight(World world) {
        return world.func_72826_c(0.0f) >= 0.245f && world.func_72826_c(0.0f) <= 0.755f;
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage) {
        Potion potion;
        List potions = ForgeRegistries.POTIONS.getValuesCollection().stream().filter(p -> {
            if (p == null) {
                return false;
            }
            return Helper.isAllowedEffect(p);
        }).collect(Collectors.toList());
        if (potions.size() > 0 && (potion = (Potion)potions.get(Helper.getRandom(0, potions.size() - 1))) != null) {
            int level;
            int random = Helper.getRandom(1, 100);
            int n = random < 10 ? 4 : (random < 25 ? 3 : (random < 45 ? 2 : (level = random < 70 ? 1 : 0)));
            if (withMessage && !potion.func_76393_a().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMagicMessage((ICommandSender)player, LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, potion.func_76393_a(), new Object[0]));
            }
            EntityHelper.addPotion((EntityLivingBase)player, potion, duration, level, new boolean[0]);
        }
    }

    public static boolean isAllowedEffect(Potion potion) {
        ResourceLocation registryName = potion.getRegistryName();
        return !potion.func_76398_f() && !Helper.containRL(ConfigTombstone.general.blackListEffects, registryName);
    }

    public static boolean containRL(String[] arrayRL, @Nullable ResourceLocation rl) {
        return rl != null && Arrays.stream(arrayRL).anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p));
    }

    public static float[] getRGBColorF(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static EnumEnchantmentType addEnchantmentType(String name, Predicate<Item> predic, EnumEnchantmentType fallback) {
        EnumEnchantmentType enchantType = EnumHelper.addEnchantmentType((String)name, predic);
        return enchantType == null ? fallback : enchantType;
    }

    public static boolean isModPresent(String modid, @Nullable String version) {
        return Loader.instance().getActiveModList().stream().filter(mod -> mod.getModId().equals(modid)).findFirst().map(mod -> version == null || mod.getProcessedVersion().compareTo((Object)new DefaultArtifactVersion(version)) >= 0).orElse(false);
    }

    public static Set<Enchantment> getTombstoneEnchantments(ItemStack stack) {
        NBTTagList nbttaglist;
        boolean isEnchantedBook;
        boolean bl = isEnchantedBook = stack.func_77973_b() == Items.field_151134_bR;
        if (!isEnchantedBook && ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() && ConfigTombstone.enchantments.isEnableEnchantmentShadowStep()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet list = Sets.newLinkedHashSet();
        NBTTagList nBTTagList = nbttaglist = isEnchantedBook ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        if (nbttaglist.func_74745_c() > 0) {
            int soulboundId = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)ModEnchantments.soulbound);
            int shadowStepId = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)ModEnchantments.shadow_step);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                boolean isSoulBound;
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                if (!nbttagcompound.func_150297_b("id", 2)) continue;
                short id = nbttagcompound.func_74765_d("id");
                boolean bl2 = isSoulBound = soulboundId == id;
                if (!isSoulBound && shadowStepId != id) continue;
                list.add(isSoulBound ? ModEnchantments.soulbound : ModEnchantments.shadow_step);
            }
        }
        return list;
    }
}

