/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TeleportUtils;

public class CommandTBRecovery
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbrecovery";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1 || args.length > 4) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EnumCommandAction action = EnumCommandAction.getAction(args[0]);
        if (action == null || action == EnumCommandAction.SAVE_ALL_PLAYERS && args.length != 1 || action == EnumCommandAction.LOAD_PLAYER && args.length != 3 || action == EnumCommandAction.SAVE_PLAYER && args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length > 1 ? CommandTBRecovery.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]) : null;
        switch (action) {
            case LOAD_PLAYER: {
                this.checkAlive((Entity)player);
                this.checkNotSpectator((EntityPlayer)player);
                this.loadPlayer(sender, player, args[2]);
                break;
            }
            case SAVE_PLAYER: {
                this.checkAlive((Entity)player);
                this.checkNotSpectator((EntityPlayer)player);
                CommandTBRecovery.savePlayer(player, success -> CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getKey(), (Object[])new Object[]{player.func_70005_c_()}));
                break;
            }
            case SAVE_ALL_PLAYERS: {
                CommandTBRecovery.saveAllPlayers(server, success -> CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(success != false ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).getKey(), (Object[])new Object[0]));
            }
        }
    }

    public static void saveAllPlayers(MinecraftServer server, Consumer<Boolean> callback) {
        File baseFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            LangKey.MESSAGE_RECOVERY_CANT_CREATE_FOLDER.sendLog(new Object[0]);
            callback.accept(false);
            return;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        boolean hasPlayerSkipped = false;
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (player.field_70128_L || player.func_175149_v()) continue;
            File playerFolder = CommandTBRecovery.getPlayerFolder(player);
            if (playerFolder == null) {
                hasPlayerSkipped = true;
                continue;
            }
            pairs.add(Pair.of((Object)player.func_189511_e(new NBTTagCompound()), (Object)playerFolder));
        }
        if (pairs.size() == 0) {
            callback.accept(true);
            return;
        }
        boolean skipped = hasPlayerSkipped;
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            boolean wasSuccessful = !skipped;
            for (Pair pair : pairs) {
                boolean success = CommandTBRecovery.savePlayerData((NBTTagCompound)pair.getLeft(), (File)pair.getRight());
                if (success) continue;
                wasSuccessful = false;
            }
            boolean isSuccessful = wasSuccessful;
            server.func_152344_a(() -> callback.accept(isSuccessful));
            return false;
        });
    }

    private static void savePlayer(EntityPlayerMP player, Consumer<Boolean> callback) {
        File playerFolder = CommandTBRecovery.getPlayerFolder(player);
        if (playerFolder == null) {
            callback.accept(false);
            return;
        }
        MinecraftServer listener = player.field_71133_b;
        NBTTagCompound tag = player.func_189511_e(new NBTTagCompound());
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> CommandTBRecovery.lambda$savePlayer$5(tag, playerFolder, (IThreadListener)listener, callback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean savePlayerData(NBTTagCompound tag, File saveFolder) {
        String dateString = new SimpleDateFormat("yyyyMMdd-hhmmss", Locale.US).format(new Date());
        try (FileWriter writer = new FileWriter(new File(saveFolder, dateString + ".save"));){
            writer.write(tag.toString());
            writer.close();
            File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles != null && matchingFiles.length > ConfigTombstone.recovery.recoveryPlayerMaxSaves) {
                Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                int num = 0;
                int adjust = matchingFiles.length - ConfigTombstone.recovery.recoveryPlayerMaxSaves;
                File[] fileArray = matchingFiles;
                int n = fileArray.length;
                for (int i = 0; i < n; ++num, ++i) {
                    File file2 = fileArray[i];
                    if (num >= adjust) break;
                    file2.delete();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    private static File getPlayerFolder(EntityPlayerMP player) {
        File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + player.func_110124_au());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            LangKey.MESSAGE_RECOVERY_CANT_CREATE_FOLDER.sendLog(new Object[0]);
            return null;
        }
        return saveFolder;
    }

    private void loadPlayer(ICommandSender sender, EntityPlayerMP player, String fileString) throws CommandException {
        block22: {
            String fileName;
            File saveFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + player.func_110124_au());
            if (!saveFolder.exists()) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FOLDER.getKey(), new Object[]{saveFolder.getAbsolutePath()});
            }
            if (fileString.equals(".latest") || fileString.equals(".oldest")) {
                File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
                if (saveFiles == null || saveFiles.length == 0) {
                    throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FOLDER.getKey(), new Object[]{fileString});
                }
                Optional<File> res = fileString.equals(".latest") ? Stream.of(saveFiles).max(File::compareTo) : Stream.of(saveFiles).min(File::compareTo);
                fileName = res.get().getName();
            } else {
                fileName = fileString + ".save";
                File[] files = saveFolder.listFiles(p -> p.isFile() && p.getName().equals(fileName));
                if (files == null || files.length == 0) {
                    throw new CommandException(LangKey.MESSAGE_RECOVERY_NO_FILE.getKey(), new Object[]{fileName});
                }
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(saveFolder, fileName)));){
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)reader.readLine());
                reader.close();
                if (!nbt.func_150296_c().isEmpty()) {
                    int originalDim = player.field_71093_bK;
                    player.deserializeNBT(nbt);
                    TeleportUtils.teleportEntity((Entity)player, player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    if (originalDim == player.field_71093_bK) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
                        for (PotionEffect potioneffect : player.func_70651_bq()) {
                            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
                        }
                    }
                    LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_TARGET_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
                    CommandTBRecovery.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_SUCCESS.getKey(), (Object[])new Object[]{player.func_70005_c_()});
                    break block22;
                }
                throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getKey(), new Object[]{player.func_70005_c_()});
            }
            catch (Exception e) {
                throw new CommandException(LangKey.MESSAGE_RECOVERY_LOAD_PLAYER_FAILED.getKey(), new Object[]{player.func_70005_c_()});
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTBRecovery.func_175762_a((String[])args, (Collection)Stream.of(EnumCommandAction.values()).map(EnumCommandAction::getName).collect(Collectors.toList()));
        }
        if (args.length == 2) {
            EnumCommandAction action = EnumCommandAction.getAction(args[0]);
            if (action == null || action == EnumCommandAction.SAVE_ALL_PLAYERS) {
                return Collections.emptyList();
            }
            return CommandTBRecovery.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            EnumCommandAction action = EnumCommandAction.getAction(args[0]);
            if (action != EnumCommandAction.LOAD_PLAYER) {
                return Collections.emptyList();
            }
            EntityPlayerMP player = server.func_184103_al().func_152612_a(args[1]);
            if (player == null) {
                return Collections.emptyList();
            }
            File checkedFile = new File(DimensionManager.getCurrentSaveRootDirectory(), "tombstone/saved_players/" + player.func_110124_au());
            if (!checkedFile.exists()) {
                return Collections.emptyList();
            }
            File[] matchingFiles = checkedFile.listFiles((file, name) -> name.endsWith(".save"));
            if (matchingFiles == null) {
                return Collections.emptyList();
            }
            List<String> list = Arrays.stream(matchingFiles).map(p -> p.getName().replace(".save", "")).collect(Collectors.toList());
            list.add(".latest");
            list.add(".oldest");
            return list;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$savePlayer$5(NBTTagCompound tag, File playerFolder, IThreadListener listener, Consumer callback) {
        boolean result = CommandTBRecovery.savePlayerData(tag, playerFolder);
        listener.func_152344_a(() -> callback.accept(result));
        return false;
    }

    public static enum EnumCommandAction {
        SAVE_ALL_PLAYERS("save_all_players"),
        SAVE_PLAYER("save_player"),
        LOAD_PLAYER("load_player");

        private final String name;

        private EnumCommandAction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static EnumCommandAction getAction(String name) {
            return Arrays.stream(EnumCommandAction.values()).filter(p -> p.getName().equals(name)).findFirst().orElse(null);
        }
    }
}

