/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.blocks;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.blocks.BlockBarrel;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.tileentity.TileFaucet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFaucet
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", input -> input != EnumFacing.DOWN);
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;

    public BlockFaucet() {
        super(Material.field_151576_e);
        this.func_149647_a(Ceramics.tab);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CONNECTED});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing face;
        if (meta >= EnumFacing.values().length) {
            meta = 1;
        }
        if ((face = EnumFacing.values()[meta]) == EnumFacing.DOWN) {
            face = EnumFacing.UP;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).activate();
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState stateIn, IBlockAccess world, BlockPos pos) {
        Block back;
        IBlockState state = super.func_176221_a(stateIn, world, pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing != EnumFacing.UP && (back = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c()) instanceof BlockBarrel) {
            state = state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileFaucet) {
            ((TileFaucet)te).handleRedstone(worldIn.func_175640_z(pos));
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileFaucet();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing = facing.func_176734_d();
        if (enumfacing == EnumFacing.DOWN) {
            enumfacing = placer.func_174811_aO().func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (Config.faucetEnabled) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.25, 0.625, 0.25, 0.75, 1.0, 0.75));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.625, 0.375));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.25, 0.25, 0.625, 0.75, 0.625, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.625, 0.25, 0.25, 1.0, 0.625, 0.75));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.25, 0.25, 0.375, 0.625, 0.75));
        builder.put((Object)EnumFacing.DOWN, (Object)field_185505_j);
        BOUNDS = builder.build();
    }
}

