/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Random;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FeatureBigMushroom
extends Feature {
    private IBlockState mushroomCap;
    private IBlockState mushroomStem;
    private IBlockState blockToPlaceOn;
    private Shape shape;

    public FeatureBigMushroom(Config config) {
        super(config);
        this.mushroomCap = config.getBlock("mushroomCap", Blocks.field_180401_cv.func_176223_P());
        this.mushroomStem = config.getBlock("mushroomStem", Blocks.field_180401_cv.func_176223_P());
        this.blockToPlaceOn = config.getBlock("blockToPlaceOn", Blocks.field_180401_cv.func_176223_P());
        this.shape = config.getEnum("shape", Shape.class, Shape.FLAT);
    }

    public FeatureBigMushroom(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState mushroomCap, IBlockState mushroomStem, IBlockState blockToPlaceOn, Shape shape) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.mushroomCap = mushroomCap;
        this.mushroomStem = mushroomStem;
        this.blockToPlaceOn = blockToPlaceOn;
        this.shape = shape;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.mushroomCap.func_177230_c() == Blocks.field_180401_cv || this.mushroomStem.func_177230_c() == Blocks.field_180401_cv || this.blockToPlaceOn.func_177230_c() == Blocks.field_180401_cv) {
            return false;
        }
        int stemHeight = rand.nextInt(3) + 4;
        if (rand.nextInt(12) == 0) {
            stemHeight *= 2;
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + stemHeight + 1 < 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + stemHeight; ++y) {
                int k = 3;
                if (y <= pos.func_177956_o() + 3) {
                    k = 0;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - k; x <= pos.func_177958_n() + k && flag; ++x) {
                    for (int z = pos.func_177952_p() - k; z <= pos.func_177952_p() + k && flag; ++z) {
                        if (y >= 0 && y < 256) {
                            IBlockState state = world.func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z));
                            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)mutablePos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)mutablePos)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (world.func_180495_p(pos.func_177977_b()) != this.blockToPlaceOn) {
                return false;
            }
            int k2 = pos.func_177956_o() + stemHeight;
            if (this.shape == Shape.BULB) {
                k2 = pos.func_177956_o() + stemHeight - 3;
            }
            for (int l2 = k2; l2 <= pos.func_177956_o() + stemHeight; ++l2) {
                int j3 = 1;
                if (l2 < pos.func_177956_o() + stemHeight) {
                    ++j3;
                }
                if (this.shape == Shape.FLAT) {
                    j3 = 3;
                }
                int k3 = pos.func_177958_n() - j3;
                int l3 = pos.func_177958_n() + j3;
                int j1 = pos.func_177952_p() - j3;
                int k1 = pos.func_177952_p() + j3;
                for (int l1 = k3; l1 <= l3; ++l1) {
                    for (int i2 = j1; i2 <= k1; ++i2) {
                        BlockPos blockpos;
                        IBlockState state;
                        int j2 = 5;
                        if (l1 == k3) {
                            --j2;
                        } else if (l1 == l3) {
                            ++j2;
                        }
                        if (i2 == j1) {
                            j2 -= 3;
                        } else if (i2 == k1) {
                            j2 += 3;
                        }
                        BlockHugeMushroom.EnumType mushroomType = BlockHugeMushroom.EnumType.func_176895_a((int)j2);
                        if (this.shape == Shape.FLAT || l2 < pos.func_177956_o() + stemHeight) {
                            if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                            if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == j1) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == k3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == j1) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == l3 && i2 == pos.func_177952_p() - (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == pos.func_177958_n() - (j3 - 1) && i2 == k1) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == k3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == pos.func_177958_n() + (j3 - 1) && i2 == k1) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                            if (l1 == l3 && i2 == pos.func_177952_p() + (j3 - 1)) {
                                mushroomType = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                        }
                        if (mushroomType == BlockHugeMushroom.EnumType.CENTER && l2 < pos.func_177956_o() + stemHeight) {
                            mushroomType = BlockHugeMushroom.EnumType.ALL_INSIDE;
                        }
                        if (pos.func_177956_o() < pos.func_177956_o() + stemHeight - 1 && mushroomType == BlockHugeMushroom.EnumType.ALL_INSIDE || !(state = world.func_180495_p(blockpos = new BlockPos(l1, l2, i2))).func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                        this.func_175903_a(world, blockpos, this.mushroomCap);
                    }
                }
            }
            for (int i3 = 0; i3 < stemHeight; ++i3) {
                IBlockState iblockstate = world.func_180495_p(pos.func_177981_b(i3));
                if (!iblockstate.func_177230_c().canBeReplacedByLeaves(iblockstate, (IBlockAccess)world, pos.func_177981_b(i3))) continue;
                this.func_175903_a(world, pos.func_177981_b(i3), this.mushroomStem);
            }
            return true;
        }
        return false;
    }

    public static enum Shape {
        FLAT,
        BULB;

    }
}

