/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_core.utils;

import com.globbypotato.rockhounding_core.handlers.ModConfig;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import com.globbypotato.rockhounding_core.utils.FuelUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.oredict.OreDictionary;

public class CoreUtils {
    public static boolean hasWrench(EntityPlayer player) {
        return !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77969_a(CoreBasics.mod_wrench);
    }

    public static boolean hasTool(EntityPlayer player, ItemStack heldItem) {
        return !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77969_a(heldItem);
    }

    public static boolean hasConsumable(ItemStack consumable, ItemStack insertingStack) {
        return !insertingStack.func_190926_b() && ItemStack.func_185132_d((ItemStack)consumable, (ItemStack)insertingStack) && insertingStack.func_77952_i() < insertingStack.func_77958_k();
    }

    public static boolean hasConsumable(ItemStack consumable, ItemStack insertingStack, int step) {
        return !insertingStack.func_190926_b() && ItemStack.func_185132_d((ItemStack)consumable, (ItemStack)insertingStack) && insertingStack.func_77952_i() <= insertingStack.func_77958_k() - step;
    }

    public static ArrayList<Integer> intArrayToList(int[] array) {
        ArrayList<Integer> temp = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            temp.add(array[i]);
        }
        return temp;
    }

    public static boolean isMatchingIngredient(ItemStack recipeIngredient, ItemStack slotIngredient) {
        if (!recipeIngredient.func_190926_b() && !slotIngredient.func_190926_b()) {
            ArrayList<Integer> inputIDs = CoreUtils.intArrayToList(OreDictionary.getOreIDs((ItemStack)slotIngredient));
            ArrayList<Integer> recipeIDs = CoreUtils.intArrayToList(OreDictionary.getOreIDs((ItemStack)recipeIngredient));
            if (!inputIDs.isEmpty() && inputIDs.size() > 0 && !recipeIDs.isEmpty() && recipeIDs.size() > 0 && CoreUtils.compareDictArrays(inputIDs, recipeIDs)) {
                return true;
            }
            return ItemStack.func_179545_c((ItemStack)recipeIngredient, (ItemStack)slotIngredient);
        }
        return false;
    }

    public static boolean isMatchingIngredient(ItemStack recipeIngredient, boolean canOredict, ItemStack slotIngredient) {
        if (!recipeIngredient.func_190926_b() && !slotIngredient.func_190926_b()) {
            if (canOredict) {
                ArrayList<Integer> inputIDs = CoreUtils.intArrayToList(OreDictionary.getOreIDs((ItemStack)slotIngredient));
                ArrayList<Integer> recipeIDs = CoreUtils.intArrayToList(OreDictionary.getOreIDs((ItemStack)recipeIngredient));
                if (!inputIDs.isEmpty() && inputIDs.size() > 0 && !recipeIDs.isEmpty() && recipeIDs.size() > 0 && CoreUtils.compareDictArrays(inputIDs, recipeIDs)) {
                    return true;
                }
            }
            return ItemStack.func_179545_c((ItemStack)recipeIngredient, (ItemStack)slotIngredient);
        }
        return false;
    }

    public static ItemStack getModdedStack(Item item, int num, int meta) {
        return item != null ? new ItemStack(item, num, meta) : ItemStack.field_190927_a;
    }

    public static ItemStack getModdedStack(Block block, int num, int meta) {
        return block != null ? new ItemStack(block, num, meta) : ItemStack.field_190927_a;
    }

    public static boolean compareDictArrays(ArrayList<Integer> inputOreIDs, ArrayList<Integer> recipeOreIDs) {
        for (Integer recipeID : recipeOreIDs) {
            String recipeName = OreDictionary.getOreName((int)recipeID);
            for (Integer inputID : inputOreIDs) {
                String inputName = OreDictionary.getOreName((int)inputID);
                if (!inputName.matches(recipeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getEnchantmentLevel(Enchantment enchantment, ItemStack consumable) {
        int j = 0;
        if (!consumable.func_190926_b() && consumable.func_77952_i() < consumable.func_77958_k()) {
            j = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)consumable);
        }
        return j;
    }

    public static FluidStack getFluid(String fluidName, int amount) {
        return CoreUtils.fluidExists(fluidName) ? new FluidStack(FluidRegistry.getFluid((String)fluidName), amount) : null;
    }

    public static boolean fluidExists(String fluidname) {
        return FluidRegistry.isFluidRegistered((String)fluidname);
    }

    public static boolean isBucketType(ItemStack insertingStack) {
        return !insertingStack.func_190926_b() && (insertingStack.func_77973_b() instanceof ItemBucket || insertingStack.func_77973_b() instanceof UniversalBucket);
    }

    public static ItemStack getFluidBucket(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static boolean isEmptyBucket(ItemStack insertingStack) {
        return !insertingStack.func_190926_b() && (insertingStack.func_77973_b() == Items.field_151133_ar || insertingStack.func_77973_b() instanceof UniversalBucket && FluidUtil.getFluidContained((ItemStack)insertingStack).containsFluid(null));
    }

    public static boolean hasInductor(ItemStack insertingStack) {
        return !insertingStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)insertingStack, (ItemStack)CoreBasics.heat_inductor);
    }

    public static boolean hasBlend(ItemStack insertingStack) {
        return !insertingStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)insertingStack, (ItemStack)CoreBasics.fuel_blend);
    }

    public static boolean isPowerSource(ItemStack insertingStack) {
        return !ModConfig.enableFuelBlend && FuelUtils.isItemFuel(insertingStack) || CoreUtils.hasInductor(insertingStack) || ModConfig.enableFuelBlend && CoreUtils.hasBlend(insertingStack);
    }
}

