/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.u_team_core.tileentity.UTileEntityProvider;
import info.u_team.useful_railroads.block.BlockTileEntityCustomRailPowered;
import info.u_team.useful_railroads.item.ItemBlockRailTeleport;
import info.u_team.useful_railroads.tilentity.TileEntityRailTeleport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRailTeleport
extends BlockTileEntityCustomRailPowered {
    public BlockRailTeleport(String name) {
        super(name, new UTileEntityProvider(new ResourceLocation("usefulrailroads", name + "_tile"), TileEntityRailTeleport.class, new Object[0]));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityRailTeleport)) {
            return false;
        }
        TileEntityRailTeleport rail = (TileEntityRailTeleport)tile;
        if (rail.getTeleportPos().func_177956_o() < -2000000000) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "You have not setup the rail yet."));
            return true;
        }
        player.openGui((Object)"usefulrailroads", 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public void onMinecartPassPowered(World world, EntityMinecart cart, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityRailTeleport)) {
            return;
        }
        TileEntityRailTeleport rail = (TileEntityRailTeleport)tile;
        rail.teleport(world, cart, pos);
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockRailTeleport((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(this.getItem());
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRailTeleport && world.field_72995_K) {
            TileEntityRailTeleport rail = (TileEntityRailTeleport)tile;
            stack.func_77982_d(this.getTag(rail));
        }
        return stack;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.func_184812_l_()) {
            if (!world.field_72995_K) {
                this.func_180657_a(world, player, pos, state, null, player.func_184614_ca());
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            ItemStack stack = new ItemStack(this.getItem());
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityRailTeleport) {
                TileEntityRailTeleport rail = (TileEntityRailTeleport)tile;
                stack.func_77982_d(this.getTag(rail));
            }
            BlockRailTeleport.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public NBTTagCompound getTag(TileEntityRailTeleport rail) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", rail.getDimension());
        BlockPos teleportPos = rail.getTeleportPos();
        compound.func_74768_a("x", teleportPos.func_177958_n());
        compound.func_74768_a("y", teleportPos.func_177956_o());
        compound.func_74768_a("z", teleportPos.func_177952_p());
        if (rail.getFuel() > 0) {
            compound.func_74768_a("fuel", rail.getFuel());
        }
        return compound;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }
}

