/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.ddssutils.world.biomes;

import java.util.Random;
import me.dierke9.ddssutils.handlers.RockHandler;
import me.dierke9.ddssutils.world.NoiseProvider;
import me.dierke9.ddssutils.world.util.FreebiChunkProvider;
import me.dierke9.ddssutils.world.util.OpenSimplexNoise;
import me.dierke9.ddssutils.world.util.UniversalConstants;
import me.dierke9.ddssutils.world.util.subbiome.FreebiBiome;
import me.dierke9.ddssutils.world.util.subbiome.FreebiBiomes;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeFreebi
extends Biome
implements UniversalConstants {
    private final WorldGenAbstractTree TROPICAL_TREE_FEATURE = new WorldGenMegaJungle(false, 10, 20, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
    private final WorldGenAbstractTree TEMPERATE_TREE_FEATURE = new WorldGenTrees(false, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), false);
    private final WorldGenAbstractTree COOL_TREE_FEATURE = new WorldGenMegaPineTree(false, true);
    private final WorldGenAbstractTree TEMPERATE_SHRUB = new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
    private final WorldGenAbstractTree COOL_SHRUB = new WorldGenShrub(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
    public FreebiChunkProvider provider;

    public BiomeFreebi(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76808_K = false;
        this.field_76760_I.field_76832_z = -999;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int posX, int posZ, double noiseVal) {
        NoiseProvider.init(worldIn);
        this.provider = new FreebiChunkProvider();
        int x = posX & 0xF;
        int z = posZ & 0xF;
        OpenSimplexNoise rockNoise = new OpenSimplexNoise(BiomeFreebi.inc(worldIn.func_72905_C()));
        OpenSimplexNoise layerNoise = new OpenSimplexNoise(BiomeFreebi.inc(worldIn.func_72905_C()));
        RockHandler rockAccess = new RockHandler(rockNoise, layerNoise);
        FreebiBiome subBiome = this.provider.getBiome(worldIn, posX, posZ);
        int n = subBiome.getHeight(posX, posZ);
        if (subBiome instanceof FreebiBiomes.FreebiSpecial) {
            double d2 = 0.5 * (((FreebiBiomes.FreebiSpecial)subBiome).d0 + ((FreebiBiomes.FreebiSpecial)subBiome).d1);
            double heightDifference = (double)FreebiBiomes.HIGHLAND.getHeight(posX, posZ) - (double)FreebiBiomes.LOWLAND.getHeight(posX, posZ);
            double n1 = (double)FreebiBiomes.LOWLAND.getHeight(posX, posZ) + BiomeFreebi.sigmoidScale(d2, 0.4, 20.0) * heightDifference;
            n = (int)Math.round(n1);
        }
        for (int v = 255; v >= 0; --v) {
            if (v < 1 + rand.nextInt(3)) {
                chunkPrimerIn.func_177855_a(x, v, z, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (v < n) {
                if (v >= n - 1) {
                    chunkPrimerIn.func_177855_a(x, v, z, Blocks.field_150349_c.func_176223_P());
                    continue;
                }
                if (v >= n - 3 - rand.nextInt(2)) {
                    chunkPrimerIn.func_177855_a(x, v, z, Blocks.field_150346_d.func_176223_P());
                    continue;
                }
                chunkPrimerIn.func_177855_a(x, v, z, rockAccess.getRockAtPos(new BlockPos(posX, v, posZ)));
                continue;
            }
            chunkPrimerIn.func_177855_a(x, v, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            int count = this.getTreeCount(worldIn, pos);
            boolean flag = false;
            if (count == -2) {
                flag = true;
                count = 1;
            }
            for (int j2 = 0; j2 < count; ++j2) {
                int k6 = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = this.getTreeFeatureAt(worldIn, pos.func_177982_a(k6, 0, l), flag);
                worldgenabstracttree.func_175904_e();
                int yOffset = worldgenabstracttree == this.TEMPERATE_TREE_FEATURE ? 0 : -2;
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k6, yOffset, l));
                if (!worldgenabstracttree.func_180709_b(worldIn, rand, blockpos)) continue;
                worldgenabstracttree.func_180711_a(worldIn, rand, blockpos);
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    private WorldGenAbstractTree getTreeFeatureAt(World worldIn, BlockPos pos, boolean flag) {
        OpenSimplexNoise seednoise = new OpenSimplexNoise(BiomeFreebi.inc(worldIn.func_72905_C()));
        double val0 = seednoise.eval((double)pos.func_177958_n() / 630.0, (double)pos.func_177952_p() / 630.0);
        if (val0 > 0.42) {
            return this.TROPICAL_TREE_FEATURE;
        }
        if (val0 > -0.42) {
            return flag ? this.TEMPERATE_SHRUB : this.TEMPERATE_TREE_FEATURE;
        }
        return flag ? this.COOL_SHRUB : this.COOL_TREE_FEATURE;
    }

    public static final long inc(long val0) {
        if (val0 == Long.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        return val0 + 1L;
    }

    private int getTreeCount(World worldIn, BlockPos pos) {
        int groveIncrease;
        OpenSimplexNoise seednoise = new OpenSimplexNoise(worldIn.func_72905_C());
        double noiseval = seednoise.eval((double)pos.func_177958_n() / 102.0, (double)pos.func_177952_p() / 102.0) + 1.0;
        double groveChance = seednoise.eval(((double)pos.func_177958_n() + 1.0) / 128.0, ((double)pos.func_177952_p() + 1.0) / 128.0);
        int n = groveChance < (double)0.93f ? 0 : (groveIncrease = groveChance < (double)0.95f ? 6 : 10);
        if (noiseval < 0.4 && groveIncrease == 0) {
            return -2;
        }
        int treeCount = MathHelper.func_76128_c((double)(noiseval * 5.0));
        return treeCount + groveIncrease;
    }

    private static double sigmoidScale(double d2in, double constant, double edgeClamp) {
        double evalStretch = (d2in - constant / 2.0) / (constant / edgeClamp);
        return BiomeFreebi.sigmoid(evalStretch);
    }

    private static double sigmoid(double xIn) {
        return 1.0 / (1.0 + Math.exp(-xIn));
    }
}

