/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.ddssutils.handlers;

import me.dierke9.ddssutils.init.BlockWorldRegistry;
import me.dierke9.ddssutils.world.NoiseProvider;
import me.dierke9.ddssutils.world.util.OpenSimplexNoise;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class RockHandler {
    private final NoiseProvider.NoiseOctave layer0;
    private final NoiseProvider.NoiseOctave layer1;
    private final NoiseProvider.NoiseOctave layer2;
    private final NoiseProvider.NoiseOctave cutoff1;
    private final NoiseProvider.NoiseOctave cutoff2;

    public RockHandler(OpenSimplexNoise rockNoise, OpenSimplexNoise cutoffNoise) {
        this.layer0 = new NoiseProvider.NoiseOctave(rockNoise, 0.008);
        this.layer1 = new NoiseProvider.NoiseOctave(rockNoise, 0.007, 1.0, 1.0);
        this.layer2 = new NoiseProvider.NoiseOctave(rockNoise, 0.006, 1.0, 1.0);
        this.cutoff1 = new NoiseProvider.NoiseOctave(cutoffNoise, 0.05, 9.0, 5.0);
        this.cutoff2 = new NoiseProvider.NoiseOctave(cutoffNoise, 0.05, 6.0, 3.0);
    }

    public IBlockState getRockAtPos(BlockPos pos) {
        switch (this.getRockLayerAtPos(pos)) {
            case 0: {
                return this.getTopRock(pos);
            }
            case 1: {
                return this.getMidRock(pos);
            }
            case 2: {
                return this.getFloorRock(pos);
            }
        }
        return null;
    }

    private IBlockState getTopRock(BlockPos pos) {
        double d = this.layer0.eval2d(pos.func_177958_n(), pos.func_177952_p());
        if (d > 0.33) {
            return BlockWorldRegistry.ROCK_BASIC_SCORIA.func_176223_P();
        }
        if (d > -0.33) {
            return BlockWorldRegistry.ROCK_BASIC_SLATE.func_176223_P();
        }
        return BlockWorldRegistry.ROCK_BASIC_SCORIA.func_176223_P();
    }

    private IBlockState getMidRock(BlockPos pos) {
        double d = this.layer1.eval2d(pos.func_177958_n(), pos.func_177952_p());
        if (d > 0.33) {
            return BlockWorldRegistry.ROCK_MEDIUM_BASALT.func_176223_P();
        }
        if (d > -0.33) {
            return BlockWorldRegistry.ROCK_MEDIUM_DIORITE.func_176223_P();
        }
        return BlockWorldRegistry.ROCK_MEDIUM_BASALT.func_176223_P();
    }

    private IBlockState getFloorRock(BlockPos pos) {
        double d = this.layer2.eval2d(pos.func_177958_n(), pos.func_177952_p());
        if (d > 0.33) {
            return BlockWorldRegistry.ROCK_TOUGH_QUARTZITE.func_176223_P();
        }
        if (d > -0.33) {
            return BlockWorldRegistry.ROCK_TOUGH_DIABASE.func_176223_P();
        }
        return BlockWorldRegistry.ROCK_TOUGH_QUARTZITE.func_176223_P();
    }

    private int getRockLayerAtPos(BlockPos pos) {
        if ((double)pos.func_177956_o() >= 43.0 + this.cutoff1.eval2d(pos.func_177958_n(), pos.func_177952_p())) {
            return 0;
        }
        if ((double)pos.func_177956_o() >= 24.0 + this.cutoff2.eval2d(pos.func_177958_n(), pos.func_177952_p())) {
            return 1;
        }
        return 2;
    }
}

