/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.info;

import aroma1997.backup.common.info.BackupInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Date;

public class CreatingBackupInfo
extends BackupInfo {
    private final Date date;
    private final File parent;
    private final String world;

    public CreatingBackupInfo(File backup, File parent, String world, Date date) throws FileAlreadyExistsException {
        super(backup, world);
        if (backup.exists()) {
            throw new FileAlreadyExistsException("Backup with that name already exists.");
        }
        this.date = date;
        this.parent = parent;
        this.world = world;
        if (this.getInfoFile().exists()) {
            throw new FileAlreadyExistsException("Backup with that name already exisis.");
        }
    }

    public CreatingBackupInfo(File backup, File parent, String world) throws FileAlreadyExistsException {
        this(backup, parent, world, new Date());
    }

    @Override
    public Date getBackupDate() {
        return this.date;
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    public void createInfoFile() throws IOException {
        File file = this.getInfoFile();
        file.getParentFile().mkdirs();
        PrintStream ps = new PrintStream(file);
        ps.println("#=============================================");
        ps.println("#This is an important file for your backups.");
        ps.println("#Do not move, edit or delete this file.");
        ps.println("#If you do, backups may not be automatically restorable.");
        ps.println("#=============================================");
        ps.println("date:" + this.date.getTime());
        ps.println("parent:" + (this.parent == null ? null : this.parent.getCanonicalPath()));
        ps.println("world:" + this.world);
        ps.flush();
        ps.close();
    }
}

