/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.transformation;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.utils.transformation.DoorTransformation;
import net.minecraft.nbt.NBTTagCompound;

public class OrdinaryDoorTransformation
extends DoorTransformation {
    public Rotation rotation;

    public OrdinaryDoorTransformation() {
    }

    public OrdinaryDoorTransformation(Rotation rotation) {
        this.rotation = rotation;
    }

    @Override
    public void performTransformation(EntityDoorAnimation animation, double progress) {
        switch (this.rotation) {
            case X_CLOCKWISE: {
                animation.rotXTo(-90.0 + progress * 90.0);
                break;
            }
            case X_COUNTER_CLOCKWISE: {
                animation.rotXTo((1.0 - progress) * 90.0);
                break;
            }
            case Y_CLOCKWISE: {
                animation.rotYTo(-90.0 + progress * 90.0);
                break;
            }
            case Y_COUNTER_CLOCKWISE: {
                animation.rotYTo((1.0 - progress) * 90.0);
                break;
            }
            case Z_CLOCKWISE: {
                animation.rotZTo(-90.0 + progress * 90.0);
                break;
            }
            case Z_COUNTER_CLOCKWISE: {
                animation.rotZTo((1.0 - progress) * 90.0);
            }
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("rot", this.rotation.ordinal());
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        this.rotation = Rotation.values()[nbt.func_74762_e("rot")];
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OrdinaryDoorTransformation) {
            return ((OrdinaryDoorTransformation)object).rotation == this.rotation;
        }
        return false;
    }
}

