/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.placing;

import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class PlaceModeFill
extends PlacementMode {
    public PlaceModeFill(String name, PlacementMode.PreviewMode mode) {
        super(name, mode);
    }

    @Override
    public boolean checkAll() {
        return false;
    }

    @Override
    public List<BlockPos> getCoordsToCheck(HashMap<BlockPos, PlacePreviews> splittedTiles, BlockPos pos) {
        return null;
    }

    @Override
    public List<LittleTile> placeTile(TileEntityLittleTiles te, LittleTile tile, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, boolean requiresCollisionTest) {
        LittleTile newTile;
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        if (!requiresCollisionTest) {
            tiles.add(tile);
            return tiles;
        }
        ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
        List<LittleTileBox> boxes = te.cutOut(tile.box, cutout);
        for (LittleTileBox box : boxes) {
            newTile = tile.copy();
            newTile.box = box;
            tiles.add(newTile);
        }
        for (LittleTileBox box : cutout) {
            newTile = tile.copy();
            newTile.box = box;
            unplaceableTiles.add(newTile);
        }
        return tiles;
    }
}

