/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.converting;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StructureStringUtils {
    @SideOnly(value=Side.CLIENT)
    public static String exportModel(ItemStack stack) {
        if (stack != null && (PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemRecipe)) {
            JsonObject object = new JsonObject();
            NBTTagCompound nbt = new NBTTagCompound();
            LittlePreviews previews = null;
            if (stack.func_77973_b() instanceof ItemRecipe) {
                previews = LittleTilePreview.getPreview(stack);
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack);
                previews = tile.getLittlePreview(stack);
            }
            ArrayList<String> texturenames = new ArrayList<String>();
            List cubes = ((ICreativeRendered)stack.func_77973_b()).getRenderingCubes(null, null, stack);
            JsonArray elements = new JsonArray();
            for (int i = 0; i < cubes.size(); ++i) {
                RenderCubeObject cube = (RenderCubeObject)cubes.get(i);
                JsonObject element = new JsonObject();
                element.addProperty("name", "littletile_" + i);
                JsonArray positionArray = new JsonArray();
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minX * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minY * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minZ * 16.0f)));
                element.add("from", (JsonElement)positionArray);
                positionArray = new JsonArray();
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxX * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxY * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxZ * 16.0f)));
                element.add("to", (JsonElement)positionArray);
                IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(cube.getBlockState());
                JsonObject faces = new JsonObject();
                for (int j = 0; j < EnumFacing.field_82609_l.length; ++j) {
                    EnumFacing facing = EnumFacing.field_82609_l[j];
                    List quads = CreativeBakedModel.getBakedQuad(null, (RenderCubeObject)cube, null, (BlockPos)cube.getOffset(), (IBlockState)cube.getBlockState(), (IBakedModel)blockModel, null, (EnumFacing)facing, (long)0L, (boolean)true);
                    if (quads.isEmpty()) continue;
                    JsonObject face = new JsonObject();
                    BakedQuad quad = (BakedQuad)quads.get(0);
                    if (!texturenames.contains(quad.func_187508_a().func_94215_i())) {
                        texturenames.add(quad.func_187508_a().func_94215_i());
                    }
                    int iconID = texturenames.indexOf(quad.func_187508_a().func_94215_i());
                    face.addProperty("texture", "#" + iconID);
                    JsonArray uv = new JsonArray();
                    float minX = 16.0f;
                    float maxX = 0.0f;
                    float minY = 16.0f;
                    float maxY = 0.0f;
                    for (int k = 0; k < 4; ++k) {
                        int index = k * quad.getFormat().func_181719_f();
                        int uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
                        float u = quad.func_187508_a().func_188537_a(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]));
                        minX = Math.min(minX, u);
                        maxX = Math.max(maxX, u);
                        float v = quad.func_187508_a().func_188536_b(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]));
                        minY = Math.min(minY, v);
                        maxY = Math.max(maxY, v);
                    }
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(minX)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(minY)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(maxX)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(maxY)));
                    face.add("uv", (JsonElement)uv);
                    faces.add(facing.func_176610_l(), (JsonElement)face);
                }
                element.add("faces", (JsonElement)faces);
                elements.add((JsonElement)element);
            }
            object.add("elements", (JsonElement)elements);
            JsonObject textures = new JsonObject();
            for (int j = 0; j < texturenames.size(); ++j) {
                textures.addProperty("" + j, (String)texturenames.get(j));
            }
            object.add("textures", (JsonElement)textures);
            object.addProperty("__comment", "Model generated by LittleTiles");
            return object.toString();
        }
        return "";
    }

    public static String exportStructure(ItemStack stack) {
        String text = "";
        if (stack != null && (PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemRecipe)) {
            NBTTagCompound nbt = new NBTTagCompound();
            LittlePreviews previews = null;
            Object structure = null;
            if (stack.func_77973_b() instanceof ItemRecipe) {
                previews = LittleTilePreview.getPreview(stack);
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack);
                previews = tile.getLittlePreview(stack);
            }
            text = stack.func_77978_p().toString();
        }
        return text;
    }

    public static ItemStack importStructure(String input) {
        try {
            return StructureStringUtils.importStructure(JsonToNBT.func_180713_a((String)input));
        }
        catch (NBTException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public static ItemStack importStructure(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(LittleTiles.recipeAdvanced);
        if (nbt.func_74781_a("tiles") instanceof NBTTagInt) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            stack.func_77982_d(itemNBT);
            if (nbt.func_74764_b("structure")) {
                itemNBT.func_74782_a("structure", (NBTBase)nbt.func_74775_l("structure"));
            }
            String[] names = nbt.func_74779_i("names").split("\\.");
            int tiles = nbt.func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                String[] entries = nbt.func_74779_i("" + i).split("\\.");
                if (entries.length < 8) continue;
                NBTTagCompound tileNBT = new NBTTagCompound();
                LittleTileBox box = new LittleTileBox(Integer.parseInt(entries[0]), Integer.parseInt(entries[1]), Integer.parseInt(entries[2]), Integer.parseInt(entries[3]), Integer.parseInt(entries[4]), Integer.parseInt(entries[5]));
                tileNBT.func_74778_a("block", names[Integer.parseInt(entries[6])]);
                tileNBT.func_74768_a("meta", Integer.parseInt(entries[7]));
                if (entries.length >= 9) {
                    tileNBT.func_74768_a("color", Integer.parseInt(entries[8]));
                }
                box.writeToNBT("bBox", tileNBT);
                tileNBT.func_74778_a("tID", "BlockTileBlock");
                itemNBT.func_74782_a("tile" + i, (NBTBase)tileNBT);
            }
            itemNBT.func_74768_a("tiles", tiles);
        } else {
            stack.func_77982_d(nbt);
        }
        return stack;
    }
}

