/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class LittleTileVecContext {
    public LittleTileVec vec;
    public LittleGridContext context;

    public LittleTileVecContext(String name, NBTTagCompound nbt) {
        this.loadFromNBT(name, nbt);
    }

    protected void loadFromNBT(String name, NBTTagCompound nbt) {
        int[] array = nbt.func_74759_k(name);
        if (array.length == 3) {
            LittleTileVec vec = new LittleTileVec(name, nbt);
            this.context = LittleGridContext.get();
            this.vec = new LittleTileVec(vec.x, vec.y, vec.z);
        } else if (array.length == 4) {
            this.vec = new LittleTileVec(array[0], array[1], array[2]);
            this.context = LittleGridContext.get(array[3]);
        } else {
            throw new InvalidParameterException("No valid coords given " + nbt);
        }
    }

    public LittleTileVecContext(LittleGridContext context, LittleTileVec vec) {
        this.vec = vec;
        this.context = context;
    }

    public void convertTo(LittleGridContext to) {
        this.vec.convertTo(this.context, to);
        this.context = to;
    }

    public void convertToSmallest() {
        int size = this.vec.getSmallestContext(this.context);
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public void ensureBothAreEqual(LittleTileVecContext vec) {
        if (this.context != vec.context) {
            if (this.context.size > vec.context.size) {
                vec.convertTo(this.context);
            } else {
                this.convertTo(vec.context);
            }
        }
    }

    public void add(LittleTileVecContext vec) {
        this.ensureBothAreEqual(vec);
        this.vec.add(vec.vec);
        vec.convertToSmallest();
        this.convertToSmallest();
    }

    public void add(BlockPos pos) {
        this.vec.add(pos, this.context);
    }

    public void sub(LittleTileVecContext vec) {
        this.ensureBothAreEqual(vec);
        this.vec.sub(vec.vec);
        vec.convertToSmallest();
        this.convertToSmallest();
    }

    public void sub(BlockPos pos) {
        this.vec.sub(pos, this.context);
    }

    public LittleTileVecContext copy() {
        return new LittleTileVecContext(this.context, this.vec.copy());
    }

    public BlockPos getBlockPos() {
        return this.vec.getBlockPos(this.context);
    }

    public double getPosX() {
        return this.vec.getPosX(this.context);
    }

    public double getPosY() {
        return this.vec.getPosY(this.context);
    }

    public double getPosZ() {
        return this.vec.getPosZ(this.context);
    }

    public Vec3d getVec() {
        return this.vec.getVec(this.context);
    }

    public LittleTileVec getVec(LittleGridContext context) {
        if (context == this.context) {
            return this.vec.copy();
        }
        LittleTileVec newVec = this.vec.copy();
        newVec.convertTo(this.context, context);
        return newVec;
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.context.size});
    }

    public int hashCode() {
        return this.vec.hashCode();
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof LittleTileVecContext) {
            LittleTileVecContext otherVec = (LittleTileVecContext)paramObject;
            LittleGridContext oldContext = this.context;
            LittleGridContext oldContextPos = otherVec.context;
            this.ensureBothAreEqual(otherVec);
            boolean equal = this.context == otherVec.context && this.vec.equals(otherVec.vec);
            otherVec.convertTo(oldContextPos);
            this.convertTo(oldContext);
            return equal;
        }
        return super.equals(paramObject);
    }

    public String toString() {
        return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.context.size + "]";
    }
}

