/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.combine;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.combine.AdvancedCombiner;
import java.util.List;

public class StructureCombiner
extends AdvancedCombiner<LittleTile> {
    protected LittleStructure structure;
    protected boolean modifiedMainTile = false;

    public StructureCombiner(List<LittleTile> tiles, LittleStructure structure) {
        super(tiles);
        this.structure = structure;
    }

    @Override
    public void combine() {
        if (!this.structure.hasLoaded()) {
            return;
        }
        super.combine();
        if (this.modifiedMainTile) {
            this.structure.selectMainTile();
        }
    }

    @Override
    public void onCombined(LittleTile first, LittleTile second) {
        super.onCombined(first, second);
        if (!first.connection.isLink() || !second.connection.isLink()) {
            this.modifiedMainTile = true;
        }
    }

    @Override
    protected boolean shouldScan(LittleTile tile) {
        return tile.isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) == this.structure;
    }

    @Override
    protected boolean canCutOut(LittleTile tile, LittleTile toCombine) {
        return tile.isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) == this.structure && tile.canCombine(toCombine);
    }

    @Override
    public void addCuttedTile(LittleTile cutTile) {
        super.addCuttedTile(cutTile);
        this.structure.addTile(cutTile);
    }

    @Override
    protected void removeBox(int index) {
        this.structure.removeTile((LittleTile)this.tiles.get(index));
        super.removeBox(index);
    }
}

