/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.registry;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.relative.LTStructureAnnotation;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public final class LittleStructureType {
    public final String id;
    public final String category;
    public final Class<? extends LittleStructure> structureClass;
    public final LittleStructureAttribute attribute;
    public final List<StructureTypeRelative> relatives;

    LittleStructureType(String id, String category, Class<? extends LittleStructure> structureClass, LittleStructureAttribute attribute) {
        this.id = id;
        this.category = category;
        this.structureClass = structureClass;
        this.attribute = attribute;
        this.relatives = new ArrayList<StructureTypeRelative>();
        for (Field field : structureClass.getFields()) {
            if (!field.isAnnotationPresent(LTStructureAnnotation.class)) continue;
            this.relatives.add(new StructureTypeRelative(field, field.getAnnotation(LTStructureAnnotation.class)));
        }
    }

    public LittleStructure createStructure() {
        try {
            return this.structureClass.getConstructor(LittleStructureType.class).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid structure type " + this.id);
        }
    }

    public boolean equals(Object object) {
        return object instanceof LittleStructureType && ((LittleStructureType)object).structureClass == this.structureClass;
    }

    public String toString() {
        return this.structureClass.toString();
    }

    public class StructureTypeRelative {
        public final Field field;
        public final String key;
        public final String saveKey;
        public final LTStructureAnnotation annotation;

        public StructureTypeRelative(Field field, LTStructureAnnotation annotation) {
            this.field = field;
            this.key = field.getName();
            this.saveKey = annotation.saveKey().isEmpty() ? this.key : annotation.saveKey();
            this.annotation = annotation;
        }

        public void setRelative(LittleStructure structure, StructureRelative relative) {
            try {
                this.field.set(structure, relative);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }

        public StructureRelative createRelative(NBTTagCompound nbt) {
            try {
                return (StructureRelative)this.field.getType().getConstructor(String.class, NBTTagCompound.class).newInstance(this.saveKey, nbt);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public StructureRelative createAndSetRelative(LittleStructure structure, NBTTagCompound nbt) {
            StructureRelative relative = this.createRelative(nbt);
            this.setRelative(structure, relative);
            return relative;
        }

        public StructureRelative getRelative(LittleStructure structure) {
            try {
                return (StructureRelative)this.field.get(structure);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

