/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiItemListBox;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.container.SubContainerWorkbench;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.items.ItemRecipeAdvanced;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import com.creativemd.littletiles.common.utils.ingredients.StackIngredient;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiWorkbench
extends SubGui {
    public SubGuiWorkbench() {
        super(200, 200);
    }

    public void createControls() {
        this.controls.add(new GuiLabel("->", 25, 6));
        this.controls.add(new GuiButton("Craft", 70, 3, 40){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClicked(int x, int y, int button) {
                ItemStack stack1 = ((SubContainerWorkbench)SubGuiWorkbench.this.container).basic.func_70301_a(0);
                ItemStack stack2 = ((SubContainerWorkbench)SubGuiWorkbench.this.container).basic.func_70301_a(1);
                GuiItemListBox listBox = (GuiItemListBox)SubGuiWorkbench.this.get("missing");
                GuiLabel label = (GuiLabel)SubGuiWorkbench.this.get("label");
                label.caption = "";
                listBox.clear();
                if (stack1.func_190926_b()) return;
                if (stack1.func_77973_b() instanceof ItemRecipe || stack1.func_77973_b() instanceof ItemRecipeAdvanced) {
                    LittlePreviews previews = LittleTilePreview.getPreview(stack1);
                    EntityPlayer player = this.getPlayer();
                    Ingredients ingredients = IngredientUtils.getIngredients(previews);
                    try {
                        if (!LittleAction.drain(player, ingredients)) return;
                        SubGuiWorkbench.this.sendPacketToServer(new NBTTagCompound());
                        return;
                    }
                    catch (NotEnoughIngredientsException e) {
                        if (e instanceof NotEnoughIngredientsException.NotEnoughVolumeExcepion) {
                            for (BlockIngredient ingredient : ingredients.block.getIngredients()) {
                                listBox.add(ingredient.value > 1.0 ? ingredient.value + " blocks" : (int)(ingredient.value * (double)previews.context.maxTilesPerBlock) + " pixels", ingredient.getItemStack());
                            }
                            return;
                        }
                        if (e instanceof NotEnoughIngredientsException.NotEnoughColorException) {
                            ColorUnit unit = ((NotEnoughIngredientsException.NotEnoughColorException)e).missing;
                            if (unit.BLACK > 0) {
                                listBox.add(unit.getBlackDescription(), ItemStack.field_190927_a);
                            }
                            if (unit.CYAN > 0) {
                                listBox.add(unit.getCyanDescription(), ItemStack.field_190927_a);
                            }
                            if (unit.MAGENTA > 0) {
                                listBox.add(unit.getMagentaDescription(), ItemStack.field_190927_a);
                            }
                            if (unit.YELLOW <= 0) return;
                            listBox.add(unit.getYellowDescription(), ItemStack.field_190927_a);
                            return;
                        }
                        if (e instanceof NotEnoughIngredientsException.NotEnoughStackException) {
                            for (StackIngredient stack : ingredients.getStacks()) {
                                listBox.add(stack.count + "", stack.stack);
                            }
                            return;
                        }
                        label.caption = e.getLocalizedMessage();
                        label.width = GuiRenderHelper.instance.getStringWidth(label.caption) + label.getContentOffset() * 2;
                        return;
                    }
                } else {
                    SubGuiWorkbench.this.sendPacketToServer(new NBTTagCompound());
                }
            }
        });
        this.controls.add(new GuiItemListBox("missing", 5, 25, 180, 70, new ArrayList(), new ArrayList()));
        this.controls.add(new GuiLabel("label", "", 5, 102, ColorUtils.RGBAToInt((int)255, (int)50, (int)50, (int)255)));
    }
}

