/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.utils.ingredients.ColorUnit;
import com.creativemd.littletiles.common.utils.ingredients.Ingredients;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LittleActionSaw
extends LittleActionInteract {
    public boolean toLimit;
    public LittleGridContext context;
    public LittleTileBox oldBox = null;
    public LittleBoxes newBoxes;
    public LittleTileIdentifierAbsolute coord = null;
    public EnumFacing facing;

    public LittleActionSaw(BlockPos blockPos, EntityPlayer player, boolean toLimit, LittleGridContext context) {
        super(blockPos, player);
        this.toLimit = toLimit;
        this.context = context;
    }

    public LittleActionSaw() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile) {
        return new LittleTileBox(tile.box).calculateIntercept(te.getContext(), te.func_174877_v(), this.pos, this.look);
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        this.facing = moving.field_178784_b;
        if (tile.canSawResizeTile(this.facing, player)) {
            LittleTileBox box;
            EnumFacing.Axis axis = this.facing.func_176740_k();
            te.ensureMinContext(this.context);
            if (this.context != te.getContext()) {
                this.context = te.getContext();
            }
            this.oldBox = tile.box.copy();
            boolean outside = false;
            if (secondMode) {
                box = tile.box.shrink(this.facing, this.toLimit);
            } else {
                box = tile.box.grow(this.facing);
                if (tile.box.isFaceAtEdge(te.getContext(), this.facing)) {
                    BlockPos newPos = te.func_174877_v().func_177972_a(this.facing);
                    if ((box = box.createOutsideBlockBox(te.getContext(), this.facing)) == null) {
                        return false;
                    }
                    LittleGridContext context = LittleGridContext.get(box.getSmallestContext(te.getContext()));
                    te = LittleActionSaw.loadTe(player, world, newPos, false);
                    if (te == null) {
                        return false;
                    }
                    if (context != te.getContext()) {
                        if (context.size > te.getContext().size) {
                            te.ensureMinContext(context);
                        } else {
                            box.convertTo(context, te.getContext());
                        }
                    }
                    outside = true;
                }
                if (this.toLimit) {
                    LittleTileBox before = null;
                    while (!box.isFaceAtEdge(te.getContext(), this.facing) && te.isSpaceForLittleTile(box, tile)) {
                        before = box;
                        box = box.grow(this.facing);
                    }
                    if (!te.isSpaceForLittleTile(box, tile)) {
                        box = before;
                    }
                } else if (!te.isSpaceForLittleTile(box, tile)) {
                    box = null;
                }
            }
            if (box != null) {
                double amount = Math.abs(box.getPercentVolume(te.getContext()) - tile.box.getPercentVolume(te.getContext()));
                BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
                LittleTilePreview preview = tile.getPreviewTile();
                BlockIngredient ingredient = preview.getBlockIngredient(te.getContext());
                if (ingredient != null) {
                    ingredient.value = amount;
                    ingredients.addIngredient(ingredient);
                    ColorUnit unit = null;
                    if (preview.hasColor()) {
                        unit = ColorUnit.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                    }
                    if (secondMode) {
                        LittleActionSaw.addIngredients(player, ingredients, unit);
                    } else {
                        LittleActionSaw.drain(player, new Ingredients(unit, ingredients));
                    }
                }
                if (outside) {
                    LittleTile newTile = tile.copy();
                    newTile.box = box;
                    newTile.te = te;
                    newTile.place();
                    te.updateBlock();
                    this.newBoxes = new LittleBoxes(te.func_174877_v(), te.getContext());
                    this.newBoxes.addBox(newTile);
                    te.convertToSmallest();
                    return true;
                }
                tile.box = box;
                te.updateBlock();
                this.coord = new LittleTileIdentifierAbsolute(tile);
                te.convertToSmallest();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        if (this.newBoxes != null) {
            return new LittleActionDestroyBoxes(this.newBoxes);
        }
        return new LittleActionSawRevert(this.context, this.coord, this.oldBox, this.facing);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeBoolean(this.toLimit);
        LittleActionSaw.writeContext(this.context, buf);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toLimit = buf.readBoolean();
        this.context = LittleActionSaw.readContext(buf);
    }

    public static class LittleActionSawRevert
    extends LittleAction {
        public LittleTileBox oldBox;
        public LittleTileBox replacedBox;
        public LittleTileIdentifierAbsolute coord;
        public LittleTileIdentifierAbsolute newCoord;
        public EnumFacing facing;
        public LittleGridContext context;

        public LittleActionSawRevert(LittleGridContext context, LittleTileIdentifierAbsolute coord, LittleTileBox oldBox, EnumFacing facing) {
            this.coord = coord;
            this.oldBox = oldBox;
            this.facing = facing;
            this.context = context;
        }

        public LittleActionSawRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert() throws LittleActionException {
            return new LittleActionSawRevert(this.context, this.newCoord, this.replacedBox, this.facing.func_176734_d());
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            LittleTile tile = LittleActionSawRevert.getTile(player.field_70170_p, this.coord);
            if (tile.canSawResizeTile(this.facing, player)) {
                tile.te.ensureMinContext(this.context);
                if (tile.getContext() != this.context) {
                    this.oldBox.convertTo(this.context, tile.getContext());
                    this.context = tile.getContext();
                }
                double amount = Math.abs(this.oldBox.getPercentVolume(this.context) - tile.box.getPercentVolume(tile.getContext()));
                BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
                LittleTilePreview preview = tile.getPreviewTile();
                BlockIngredient ingredient = preview.getBlockIngredient(tile.getContext());
                if (ingredient != null) {
                    ingredient.value = amount;
                    ingredients.addIngredient(ingredient);
                    ColorUnit unit = null;
                    if (preview.hasColor()) {
                        unit = ColorUnit.getColors(preview.getColor());
                        unit.scaleLoose(amount);
                    }
                    if (this.oldBox.getVolume() < tile.box.getVolume()) {
                        LittleActionSawRevert.addIngredients(player, ingredients, unit);
                    } else {
                        LittleActionSawRevert.drain(player, new Ingredients(unit, ingredients));
                    }
                }
                this.replacedBox = tile.box.copy();
                tile.box = this.oldBox.copy();
                tile.te.convertToSmallest();
                tile.te.updateBlock();
                this.newCoord = new LittleTileIdentifierAbsolute(tile);
                return true;
            }
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionSawRevert.writeAbsoluteCoord(this.coord, buf);
            LittleActionSawRevert.writeLittleBox(this.oldBox, buf);
            LittleActionSawRevert.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
            LittleActionSawRevert.writeContext(this.context, buf);
        }

        public void readBytes(ByteBuf buf) {
            this.coord = LittleActionSawRevert.readAbsoluteCoord(buf);
            this.oldBox = LittleActionSawRevert.readLittleBox(buf);
            this.facing = LittleActionSawRevert.readFacing((ByteBuf)buf);
            this.context = LittleActionSawRevert.readContext(buf);
        }
    }
}

