/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionPlaceRelative
extends LittleAction {
    public PlacementHelper.PositionResult position;
    public boolean centered;
    public boolean fixed;
    public PlacementMode mode;
    public LittlePreviews previews;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceRelative(ItemStack stack, LittlePreviews previews, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) {
        this.position = position;
        this.centered = centered;
        this.fixed = fixed;
        this.mode = mode;
        this.previews = previews;
    }

    public LittleActionPlaceRelative() {
    }

    public void checkMode(LittleStructure structure) {
        if (structure != null && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, null, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        ItemStack stack = player.func_184614_ca();
        if (!LittleActionPlaceRelative.isAllowedToInteract(player, this.position.pos, true, EnumFacing.EAST)) {
            LittleActionPlaceRelative.sendBlockResetToClient((EntityPlayerMP)player, this.position.pos, null);
            return false;
        }
        if (PlacementHelper.getLittleInterface(stack) != null) {
            LittlePlaceResult tiles = this.placeTile(player, stack, player.field_70170_p, this.position, this.centered, this.fixed, this.mode);
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
            }
            return tiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        this.position.writeToBytes(buf);
        buf.writeBoolean(this.centered);
        buf.writeBoolean(this.fixed);
        LittleActionPlaceRelative.writePlacementMode(this.mode, buf);
        buf.writeBoolean(this.previews.isAbsolute());
        if (this.previews.isAbsolute()) {
            LittleActionPlaceRelative.writeAbsolutePreviews((LittleAbsolutePreviews)((LittleAbsolutePreviews)this.previews), (ByteBuf)buf);
        } else {
            LittleActionPlaceRelative.writePreviews(this.previews, buf);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.position = PlacementHelper.PositionResult.readFromBytes(buf);
        this.centered = buf.readBoolean();
        this.fixed = buf.readBoolean();
        this.mode = LittleActionPlaceRelative.readPlacementMode(buf);
        this.previews = buf.readBoolean() ? LittleActionPlaceRelative.readAbsolutePreviews((ByteBuf)buf) : LittleActionPlaceRelative.readPreviews(buf);
    }

    public LittlePlaceResult placeTile(EntityPlayer player, ItemStack stack, World world, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) throws LittleActionException {
        LittlePlaceResult placedTiles;
        PlacementHelper.PreviewResult result;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        LittleStructure structure = iTile.getLittleStructure(stack);
        this.checkMode(structure);
        if (structure != null) {
            structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        }
        if ((result = PlacementHelper.getPreviews((World)world, (LittlePreviews)this.previews, (LittleStructure)structure, (ItemStack)stack, (PlacementHelper.PositionResult)position, (boolean)centered, (boolean)fixed, (boolean)false, (PlacementMode)mode)) == null) {
            return null;
        }
        ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> removedTiles = new ArrayList<LittleTile>();
        ItemStack toPlace = stack.func_77946_l();
        if (LittleActionPlaceRelative.needIngredients(player)) {
            if (iTile.containsIngredients(stack)) {
                stack.func_190918_g(1);
            } else {
                LittleActionPlaceRelative.canDrainPreviews((EntityPlayer)player, (LittlePreviews)result.previews);
            }
        }
        if ((placedTiles = LittleActionPlaceRelative.placeTiles(world, player, result.context, result.placePreviews, structure, mode, position.pos, toPlace, unplaceableTiles, removedTiles, position.facing)) != null) {
            this.boxes = placedTiles.placedBoxes;
            if (!iTile.containsIngredients(stack)) {
                LittleActionPlaceRelative.drainPreviews((EntityPlayer)player, (LittlePreviews)placedTiles.placedPreviews);
            }
            if (!world.field_72995_K) {
                LittleActionPlaceRelative.addTilesToInventoryOrDrop(player, unplaceableTiles);
                LittleActionPlaceRelative.addTilesToInventoryOrDrop(player, removedTiles);
            }
            if (!removedTiles.isEmpty()) {
                this.destroyed = new LittleAbsolutePreviews(position.pos, result.context);
                for (LittleTile tile : removedTiles) {
                    this.destroyed.addTile(tile);
                }
            }
        } else {
            this.boxes = new LittleBoxes(position.pos, result.context);
        }
        return placedTiles;
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceRelative.placeTiles(world, null, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, List<PlacePreviewTile> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceRelative.placeTiles(world, null, context, previews, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    private static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (splitted == null) {
            return null;
        }
        List<BlockPos> coordsToCheck = mode.getCoordsToCheck(splitted, pos);
        if (LittleActionPlaceRelative.canPlaceTiles(player, world, splitted, coordsToCheck, mode)) {
            LittlePlaceResult placed = new LittlePlaceResult(pos, context);
            ArrayList<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
            ArrayList<LastPlacedTile> lastPlacedTiles = new ArrayList<LastPlacedTile>();
            for (Map.Entry<BlockPos, PlacePreviews> entry : splitted.entrySet()) {
                TileEntityLittleTiles te;
                BlockPos coord = entry.getKey();
                PlacePreviews placeTiles = entry.getValue();
                boolean hascollideBlock = false;
                int i = 0;
                while (i < placeTiles.size()) {
                    if (((PlacePreviewTile)placeTiles.get(i)).needsCollisionTest()) {
                        hascollideBlock = true;
                        ++i;
                        continue;
                    }
                    lastPlacedTiles.add(new LastPlacedTile((PlacePreviewTile)placeTiles.get(i), coord, placeTiles.context));
                    placeTiles.remove(i);
                }
                if (!hascollideBlock) continue;
                boolean requiresCollisionTest = true;
                if (!(world.func_180495_p(coord).func_177230_c() instanceof BlockTile) && world.func_180495_p(coord).func_185904_a().func_76222_j()) {
                    requiresCollisionTest = false;
                    world.func_175656_a(coord, BlockTile.getState(false, false));
                }
                if ((te = LittleActionPlaceRelative.loadTe(player, world, coord, mode.shouldConvertBlock())) == null) continue;
                te.preventUpdate = true;
                placeTiles.ensureBothAreEqual(te);
                for (int j = 0; j < placeTiles.size(); ++j) {
                    for (LittleTile LT : ((PlacePreviewTile)placeTiles.get(j)).placeTile(player, stack, coord, te.getContext(), te, structure, unplaceableTiles, removedTiles, mode, facing, requiresCollisionTest)) {
                        if (structure != null && !structure.shouldPlaceTile(LT)) continue;
                        if (!soundsToBePlayed.contains(LT.getSound())) {
                            soundsToBePlayed.add(LT.getSound());
                        }
                        if (structure != null) {
                            if (!structure.hasMainTile()) {
                                structure.setMainTile(LT);
                            } else {
                                LT.connection = structure.getStructureLink(LT);
                                LT.connection.setLoadedStructure(structure, structure.attribute);
                                structure.addTile(LT);
                            }
                        }
                        placed.addPlacedTile(LT);
                    }
                }
                te.preventUpdate = false;
                te.combineTiles();
            }
            for (int j = 0; j < lastPlacedTiles.size(); ++j) {
                for (LittleTile tile : ((LastPlacedTile)lastPlacedTiles.get((int)j)).tile.placeTile(player, stack, ((LastPlacedTile)lastPlacedTiles.get((int)j)).pos, ((LastPlacedTile)lastPlacedTiles.get((int)j)).context, null, structure, unplaceableTiles, removedTiles, mode, facing, true)) {
                    if (tile == null) continue;
                    placed.addPlacedTile(tile);
                }
            }
            if (structure != null) {
                if (structure.getMainTile() == null) {
                    throw new LittleActionException("Missing maintile of structure. Placed " + placed.placedPreviews.size() + " tile(s).");
                }
                structure.setMainTile(structure.getMainTile());
                structure.combineTiles();
                structure.placedStructure(stack);
            }
            for (int i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_184133_a((EntityPlayer)null, pos, ((SoundType)soundsToBePlayed.get(i)).func_185841_e(), SoundCategory.BLOCKS, (((SoundType)soundsToBePlayed.get(i)).func_185843_a() + 1.0f) / 2.0f, ((SoundType)soundsToBePlayed.get(i)).func_185847_b() * 0.8f);
            }
            return placed;
        }
        return null;
    }

    public static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, List<PlacePreviewTile> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (player != null) {
            if (SpecialServerConfig.isPlaceLimited(player) && LittleActionPlaceRelative.getVolume(context, previews) > (double)SpecialServerConfig.maxPlaceBlocks) {
                throw new SpecialServerConfig.NotAllowedToPlaceException();
            }
            if (SpecialServerConfig.isTransparenceyRestricted((EntityPlayer)player)) {
                for (PlacePreviewTile placePreview : previews) {
                    LittleActionPlaceRelative.isAllowedToPlacePreview(player, placePreview.preview);
                }
            }
        }
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceRelative.getSplittedTiles(context, previews, pos);
        if (player != null && !world.field_72995_K) {
            ArrayList<BlockSnapshot> snaps = new ArrayList<BlockSnapshot>();
            for (BlockPos snapPos : splitted.keySet()) {
                snaps.add(new BlockSnapshot(world, snapPos, BlockTile.getState(false, false)));
            }
            BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(snaps, world.func_180495_p(facing == null ? pos : pos.func_177972_a(facing)), player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                for (BlockPos snapPos : splitted.keySet()) {
                    LittleActionPlaceRelative.sendBlockResetToClient((EntityPlayerMP)player, pos, null);
                }
                return null;
            }
        }
        return LittleActionPlaceRelative.placeTiles(world, player, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
    }

    public static double getVolume(LittleGridContext context, List<PlacePreviewTile> tiles) {
        double volume = 0.0;
        for (PlacePreviewTile preview : tiles) {
            volume += preview.box.getPercentVolume(context);
        }
        return volume;
    }

    public static HashMap<BlockPos, PlacePreviews> getSplittedTiles(LittleGridContext context, List<PlacePreviewTile> tiles, BlockPos pos) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split(context, (HashMapList<BlockPos, PlacePreviewTile>)splitted, pos)) continue;
            return null;
        }
        HashMap<BlockPos, PlacePreviews> previews = new HashMap<BlockPos, PlacePreviews>();
        for (Map.Entry entry : splitted.entrySet()) {
            previews.put((BlockPos)entry.getKey(), new PlacePreviews(context, (List)entry.getValue()));
        }
        return previews;
    }

    public static boolean canPlaceTiles(EntityPlayer player, World world, HashMap<BlockPos, PlacePreviews> splitted, List<BlockPos> coordsToCheck, PlacementMode mode) {
        for (BlockPos pos : splitted.keySet()) {
            if (LittleActionPlaceRelative.isAllowedToInteract(player, pos, true, EnumFacing.EAST)) continue;
            LittleActionPlaceRelative.sendBlockResetToClient((EntityPlayerMP)player, pos, null);
            return false;
        }
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacePreviews tiles = splitted.get(pos);
                if (tiles == null) continue;
                boolean needsCollisionCheck = false;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                    needsCollisionCheck = true;
                    break;
                }
                if (!needsCollisionCheck) continue;
                TileEntityLittleTiles te = LittleActionPlaceRelative.loadTe(player, world, pos, false);
                if (te != null) {
                    tiles.ensureBothAreEqual(te);
                    for (int j = 0; j < tiles.size(); ++j) {
                        if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                        if (mode.checkAll()) {
                            if (te.isSpaceForLittleTile(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                            te.convertToSmallest();
                            return false;
                        }
                        if (te.isSpaceForLittleTileStructure(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                        te.convertToSmallest();
                        return false;
                    }
                    continue;
                }
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockTile || state.func_185904_a().func_76222_j() || !mode.checkAll() && LittleActionPlaceRelative.isBlockValid(state.func_177230_c()) && LittleActionPlaceRelative.canConvertBlock(player, world, pos, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static class LittlePlaceResult {
        public final LittleAbsolutePreviews placedPreviews;
        public final LittleBoxes placedBoxes;
        private BlockPos lastPos = null;
        public final List<TileEntityLittleTiles> tileEntities = new ArrayList<TileEntityLittleTiles>();

        public LittlePlaceResult(BlockPos pos, LittleGridContext context) {
            this.placedPreviews = new LittleAbsolutePreviews(pos, context);
            this.placedBoxes = new LittleBoxes(pos, context);
        }

        public void addPlacedTile(LittleTile tile) {
            if (this.lastPos == null || !this.lastPos.equals((Object)tile.te.func_174877_v())) {
                this.lastPos = tile.te.func_174877_v();
                this.tileEntities.add(tile.te);
            }
            this.placedPreviews.addTile(tile);
            this.placedBoxes.addBox(tile);
        }
    }

    public static class LastPlacedTile {
        public final PlacePreviewTile tile;
        public final BlockPos pos;
        public final LittleGridContext context;

        public LastPlacedTile(PlacePreviewTile tile, BlockPos pos, LittleGridContext context) {
            this.tile = tile;
            this.pos = pos;
            this.context = context;
        }
    }
}

