/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.structure.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public class LittleActionPlaceAbsolute
extends LittleAction {
    public LittleAbsolutePreviews previews;
    public PlacementMode mode;
    public boolean toVanilla;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceAbsolute(LittleAbsolutePreviews previews, PlacementMode mode, boolean toVanilla) {
        this.previews = previews;
        this.mode = mode;
        this.toVanilla = toVanilla;
        this.checkMode();
    }

    public LittleActionPlaceAbsolute(LittleAbsolutePreviews previews, PlacementMode mode) {
        this(previews, mode, false);
    }

    public LittleActionPlaceAbsolute() {
    }

    public void checkMode() {
        if (this.previews != null && this.previews.hasStructure() && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        if (this.canDrainIngredientsBeforePlacing(player)) {
            ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
            this.previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
            ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
            ArrayList<LittleTile> removedTiles = new ArrayList<LittleTile>();
            LittleActionPlaceStack.LittlePlaceResult placedTiles = LittleActionPlaceStack.placeTiles(player.field_70170_p, player, this.previews.context, placePreviews, this.previews.getStructure(), this.mode, this.previews.pos, null, unplaceableTiles, removedTiles, EnumFacing.EAST);
            if (placedTiles != null) {
                this.boxes = placedTiles.placedBoxes;
                this.drainIngredientsAfterPlacing(player, placedTiles, this.previews);
                if (!player.field_70170_p.field_72995_K) {
                    LittleActionPlaceAbsolute.addTilesToInventoryOrDrop(player, unplaceableTiles);
                    LittleActionPlaceAbsolute.addTilesToInventoryOrDrop(player, removedTiles);
                }
                if (!removedTiles.isEmpty()) {
                    this.destroyed = new LittleAbsolutePreviews(this.previews.pos, this.previews.context);
                    for (LittleTile tile : removedTiles) {
                        this.destroyed.addTile(tile);
                    }
                }
                if (this.toVanilla) {
                    for (TileEntityLittleTiles te : placedTiles.tileEntities) {
                        te.convertBlockToVanilla();
                    }
                }
            } else {
                this.boxes = new LittleBoxes(this.previews.pos, LittleGridContext.get());
            }
            return placedTiles != null;
        }
        return false;
    }

    protected boolean canDrainIngredientsBeforePlacing(EntityPlayer player) throws LittleActionException {
        return LittleActionPlaceAbsolute.canDrain(player, this.previews);
    }

    protected void drainIngredientsAfterPlacing(EntityPlayer player, LittleActionPlaceStack.LittlePlaceResult placedTiles, LittlePreviews previews) throws LittleActionException {
        LittleActionPlaceAbsolute.drain(player, IngredientUtils.getStructureIngredients(previews).add(IngredientUtils.getIngredients(placedTiles.placedPreviews)));
    }

    public void writeBytes(ByteBuf buf) {
        LittleActionPlaceAbsolute.writePreviews(this.previews, buf);
        LittleActionPlaceAbsolute.writePlacementMode(this.mode, buf);
        buf.writeBoolean(this.toVanilla);
    }

    public void readBytes(ByteBuf buf) {
        this.previews = (LittleAbsolutePreviews)LittleActionPlaceAbsolute.readPreviews(buf);
        this.mode = LittleActionPlaceAbsolute.readPlacementMode(buf);
        this.toVanilla = buf.readBoolean();
        this.checkMode();
    }

    public static class LittleActionPlaceAbsolutePremade
    extends LittleActionPlaceAbsolute {
        public LittleActionPlaceAbsolutePremade(LittleAbsolutePreviews previews, PlacementMode mode, boolean toVanilla) {
            super(previews, mode, toVanilla);
        }

        public LittleActionPlaceAbsolutePremade() {
        }

        @Override
        protected void drainIngredientsAfterPlacing(EntityPlayer player, LittleActionPlaceStack.LittlePlaceResult placedTiles, LittlePreviews previews) throws LittleActionException {
            LittleActionPlaceAbsolutePremade.drainPremadeItemStack(player, LittleStructurePremade.getStructurePremadeEntry((String)previews.getStructure().type.id).stack);
        }

        @Override
        protected boolean canDrainIngredientsBeforePlacing(EntityPlayer player) throws LittleActionException {
            LittleStructurePremade.LittleStructurePremadeEntry entry = LittleStructurePremade.getStructurePremadeEntry(this.previews.getStructure().type.id);
            return LittleActionPlaceAbsolutePremade.canDrainPremadeItemStack(player, entry.stack) && entry.arePreviewsEqual(this.previews);
        }
    }
}

