/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class LittleActionInteract
extends LittleAction {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;
    public boolean secondMode;

    public LittleActionInteract(BlockPos blockPos, EntityPlayer player) {
        this.blockPos = blockPos;
        this.pos = player.func_174824_e(1.0f);
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(1.0f);
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.secondMode = LittleActionInteract.isUsingSecondMode(player);
    }

    public LittleActionInteract() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleActionInteract.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleActionInteract.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleActionInteract.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeBoolean(this.secondMode);
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleActionInteract.readPos((ByteBuf)buf);
        this.pos = LittleActionInteract.readVec3d((ByteBuf)buf);
        this.look = LittleActionInteract.readVec3d((ByteBuf)buf);
        this.secondMode = buf.readBoolean();
    }

    protected abstract boolean isRightClick();

    protected abstract boolean action(World var1, TileEntityLittleTiles var2, LittleTile var3, ItemStack var4, EntityPlayer var5, RayTraceResult var6, BlockPos var7, boolean var8) throws LittleActionException;

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        World world = player.field_70170_p;
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            LittleTile tile = te.getFocusedTile(this.pos, this.look);
            if (!LittleActionInteract.isAllowedToInteract(player, this.blockPos, this.isRightClick(), EnumFacing.EAST)) {
                LittleActionInteract.sendBlockResetToClient((EntityPlayerMP)player, this.blockPos, te);
                return false;
            }
            if (tile != null) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                RayTraceResult moving = this.rayTrace(te, tile);
                return this.action(world, te, tile, stack, player, moving, this.blockPos, this.secondMode);
            }
            this.onTileNotFound();
        } else {
            this.onTileEntityNotFound();
        }
        return false;
    }

    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile) {
        return te.rayTrace(this.pos, this.look);
    }

    protected void onTileNotFound() throws LittleActionException {
        throw new LittleActionException.TileNotFoundException();
    }

    protected void onTileEntityNotFound() throws LittleActionException {
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

