/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;

public class ItemModelCache {
    private List<BakedQuad> quads;
    private long lastUsed;
    private static HashMap<ItemModelCacheKey, ItemModelCache> caches = new HashMap();
    private static int ticker = 0;
    public static int timeToExpire = 30000;
    private static int timeToCheck = timeToExpire / 50;
    public static RenderingThreadItem thread = new RenderingThreadItem();
    private static Minecraft mc = Minecraft.func_71410_x();

    public ItemModelCache(List<BakedQuad> quads) {
        this.quads = quads;
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.lastUsed >= (long)timeToExpire;
    }

    public List<BakedQuad> getQuads() {
        this.lastUsed = System.currentTimeMillis();
        return this.quads;
    }

    public static void cacheModel(ItemStack stack, EnumFacing facing, List<BakedQuad> quads) {
        ItemModelCache.cacheModel(new ItemModelCacheKey(stack, facing), quads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheModel(ItemModelCacheKey key, List<BakedQuad> quads) {
        HashMap<ItemModelCacheKey, ItemModelCache> hashMap = caches;
        synchronized (hashMap) {
            caches.put(key, new ItemModelCache(quads));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BakedQuad> requestCache(ItemStack stack, EnumFacing facing) {
        HashMap<ItemModelCacheKey, ItemModelCache> hashMap = caches;
        synchronized (hashMap) {
            ItemModelCacheKey key = new ItemModelCacheKey(stack, facing);
            ItemModelCache cache = caches.get(key);
            if (cache != null) {
                return cache.getQuads();
            }
            ItemModelCache.thread.items.add(key);
            return null;
        }
    }

    public static void tick(World world) {
        if (world == null) {
            caches.clear();
            return;
        }
        if (++ticker >= timeToCheck) {
            Iterator<ItemModelCache> iterator = caches.values().iterator();
            while (iterator.hasNext()) {
                ItemModelCache cache = iterator.next();
                if (!cache.expired()) continue;
                iterator.remove();
            }
            ticker = 0;
        }
    }

    public static class RenderingThreadItem
    extends Thread {
        public ConcurrentLinkedQueue<ItemModelCacheKey> items = new ConcurrentLinkedQueue();

        public RenderingThreadItem() {
            this.start();
        }

        @Override
        public void run() {
            WorldClient world = mc.field_71441_e;
            if (world != null && !this.items.isEmpty()) {
                ItemModelCacheKey data = this.items.poll();
                ICreativeRendered renderer = (ICreativeRendered)data.stack.func_77973_b();
                BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                ItemModelCache.cacheModel(data, CreativeBakedModel.getBlockQuads((List)renderer.getRenderingCubes(null, null, data.stack), new ArrayList(), null, (EnumFacing)data.facing, null, (BlockRenderLayer)layer, null, null, (long)0L, (ItemStack)data.stack, (boolean)true));
            } else if (this.items.isEmpty()) {
                this.items.clear();
            }
        }
    }

    private static class ItemModelCacheKey {
        public ItemStack stack;
        public EnumFacing facing;

        public ItemModelCacheKey(ItemStack stack, EnumFacing facing) {
            this.stack = stack;
            this.facing = facing;
        }

        public boolean equals(Object object) {
            if (object instanceof ItemModelCacheKey) {
                return ((ItemModelCacheKey)object).stack.equals(this.stack) && ((ItemModelCacheKey)object).facing == this.facing;
            }
            return false;
        }

        public int hashCode() {
            return this.stack.hashCode() + this.facing.hashCode();
        }
    }
}

