/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import omtteam.omlib.api.tile.IDebugTile;
import omtteam.omlib.tileentity.TileEntityElectric;
import omtteam.omlib.tileentity.TileEntityMachine;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.GeneralUtil;

public class ItemDebugTool
extends Item {
    public ItemDebugTool() {
        this.setRegistryName("omlib", "debug_tool");
        this.func_77655_b("debug_tool");
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) != null) {
            List<String> debugInfo;
            TileEntityOwnedBlock te;
            if (tileEntity instanceof TileEntityOwnedBlock) {
                te = (TileEntityOwnedBlock)tileEntity;
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Owner name is \"" + te.getOwner().getName() + "\" and UUID is " + te.getOwner().getUuid().toString()));
            }
            if (tileEntity instanceof TileEntityElectric) {
                te = (TileEntityElectric)tileEntity;
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Stored Energy: " + ((TileEntityElectric)te).getEnergyStored(EnumFacing.DOWN) + "/" + ((TileEntityElectric)te).getMaxEnergyStored(EnumFacing.DOWN)));
            }
            if (tileEntity instanceof TileEntityMachine) {
                te = (TileEntityMachine)tileEntity;
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Active: " + ((TileEntityMachine)te).isActive() + ", Redstone: " + ((TileEntityMachine)te).getRedstone() + ", Mode: " + GeneralUtil.getMachineModeLocalization(((TileEntityMachine)te).getMode())));
            }
            if (tileEntity instanceof IDebugTile && (debugInfo = ((IDebugTile)tileEntity).getDebugInfo()).size() >= 1) {
                for (String debug : debugInfo) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(debug));
                }
            }
        }
        return EnumActionResult.PASS;
    }
}

