/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.configuration;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.malisis.core.configuration.ConfigurationSetting;
import net.malisis.core.configuration.setting.Setting;
import net.minecraftforge.common.config.Configuration;

public class Settings {
    private Configuration config;
    private HashMap<String, ArrayList<Setting<?>>> categorySettings = new HashMap();

    public Settings(File file) {
        this(new Configuration(file));
    }

    public Settings(Configuration config) {
        this.config = config;
        config.load();
        this.initSettings();
        this.getSettingFields();
        config.save();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Set<String> getCategories() {
        return this.categorySettings.keySet();
    }

    public List<Setting<?>> getSettings(String category) {
        return this.categorySettings.get(category);
    }

    protected void initSettings() {
    }

    private void getSettingFields() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            ConfigurationSetting annotation = field.getAnnotation(ConfigurationSetting.class);
            if (annotation == null || field.getType() != Setting.class) continue;
            Setting setting = null;
            try {
                setting = (Setting)field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (setting == null) continue;
            String category = annotation.category();
            setting.setCategory(category);
            setting.load(this.config);
            ArrayList<Setting<Object>> settings = this.categorySettings.get(category);
            if (settings == null) {
                settings = new ArrayList();
            }
            settings.add(setting);
            this.categorySettings.put(category, settings);
        }
    }

    public void save() {
        for (Map.Entry<String, ArrayList<Setting<?>>> entry : this.categorySettings.entrySet()) {
            for (Setting<?> setting : entry.getValue()) {
                setting.save();
            }
        }
        this.config.save();
    }
}

