/*
 * Decompiled with CFR 0.152.
 */
package net.insane96mcp.vulcanite.events;

import net.insane96mcp.vulcanite.init.ModItems;
import net.insane96mcp.vulcanite.lib.Properties;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="vulcanite")
public class LivingHurt {
    static ItemStack[] armorList = new ItemStack[]{new ItemStack((Item)ModItems.vulcaniteHelmetItem), new ItemStack((Item)ModItems.vulcaniteChestplateItem), new ItemStack((Item)ModItems.vulcaniteLeggingsItem), new ItemStack((Item)ModItems.vulcaniteBootsItem)};
    static DamageSource[] validSources = new DamageSource[]{DamageSource.field_76372_a, DamageSource.field_76370_b, DamageSource.field_190095_e, DamageSource.field_76371_c};
    private static ItemStack[] vulcaniteWeapons = new ItemStack[]{new ItemStack((Item)ModItems.vulcaniteSwordItem), new ItemStack((Item)ModItems.vulcaniteAxeItem), new ItemStack((Item)ModItems.vulcanitePickaxeItem), new ItemStack((Item)ModItems.vulcaniteShovelItem)};

    @SubscribeEvent
    public static void OnPlayerHurt(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        DamageSource source = event.getSource();
        float[] materialPerPiece = new float[]{5.0f, 8.0f, 7.0f, 4.0f};
        for (DamageSource damageSource : validSources) {
            if (source != damageSource) continue;
            float amount = event.getAmount();
            int materialsUsed = 0;
            Iterable playerArmor = player.func_184193_aE();
            block1: for (ItemStack armorPiece : playerArmor) {
                for (int i = 0; i < armorList.length; ++i) {
                    if (!ItemStack.func_185132_d((ItemStack)armorPiece, (ItemStack)armorList[i])) continue;
                    materialsUsed = (int)((float)materialsUsed + materialPerPiece[i]);
                    continue block1;
                }
            }
            if (materialsUsed < true) continue;
            float maxReduction = player.field_71093_bK == -1 ? Properties.config.armor.damageReductionNether / 100.0f : Properties.config.armor.damageReductionOther / 100.0f;
            float reductionPerMaterial = maxReduction / 24.0f;
            float percentageReduction = reductionPerMaterial * (float)materialsUsed;
            event.setAmount(amount *= 1.0f - percentageReduction);
        }
    }

    @SubscribeEvent
    public static void OnPlayerDamageEntity(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getSource().func_76346_g();
        ItemStack heldItem = player.func_184614_ca();
        boolean hasVulcaniteWeapon = false;
        for (ItemStack weapon : vulcaniteWeapons) {
            if (!ItemStack.func_185132_d((ItemStack)heldItem, (ItemStack)weapon)) continue;
            hasVulcaniteWeapon = true;
            break;
        }
        if (!hasVulcaniteWeapon) {
            return;
        }
        Entity target = event.getEntity();
        if (!(target instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)target;
        if (!entity.func_70045_F()) {
            return;
        }
        float damageDealth = event.getAmount();
        float baseBonus = Properties.config.toolsAndWeapons.bonusStats.damage / 100.0f;
        float fireAspectBonus = 0.0f;
        NBTTagList enchantments = heldItem.func_77986_q();
        if (enchantments != null) {
            short fireAspectLevel = 0;
            for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                if (enchantments.func_150305_b(i).func_74765_d("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_77334_n)) continue;
                fireAspectLevel = enchantments.func_150305_b(i).func_74765_d("lvl");
            }
            fireAspectBonus = Properties.config.toolsAndWeapons.bonusStats.damageFireAspect / 100.0f * (float)fireAspectLevel;
        }
        float bonusDamageDealth = damageDealth * (baseBonus + fireAspectBonus);
        event.setAmount(damageDealth + bonusDamageDealth);
    }
}

