/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.tools;

import net.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import net.ilexiconn.llibrary.client.model.tools.Model3DTexture;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ExtendedModelRenderer
extends ModelRenderer {
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public int field_78803_o;
    public int field_78813_p;
    public boolean scaleChildren;
    private AdvancedModelBase model;
    private ExtendedModelRenderer parent;
    private int displayList;
    private boolean compiled;
    private float opacity = 1.0f;
    private boolean hasLighting = true;
    private boolean doubleSided = true;

    public ExtendedModelRenderer(AdvancedModelBase model, String name) {
        super((ModelBase)model, name);
        this.model = model;
    }

    public ExtendedModelRenderer(AdvancedModelBase model) {
        this(model, null);
    }

    public ExtendedModelRenderer(AdvancedModelBase model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public ExtendedModelRenderer add3DTexture(float posX, float posY, float posZ, int width, int height) {
        this.field_78804_l.add(new Model3DTexture((ModelRenderer)this, this.field_78803_o, this.field_78813_p, posX, posY, posZ, width, height));
        return this;
    }

    public ModelRenderer func_78786_a(String partName, float offX, float offY, float offZ, int width, int height, int depth) {
        partName = this.field_78802_n + "." + partName;
        TextureOffset textureoffset = this.model.func_78084_a(partName);
        this.setTextureOffset(textureoffset.field_78783_a, textureoffset.field_78782_b);
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f).func_78244_a(partName));
        return this;
    }

    public ModelRenderer func_78789_a(float offX, float offY, float offZ, int width, int height, int depth) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f));
        return this;
    }

    public ModelRenderer func_178769_a(float offX, float offY, float offZ, int width, int height, int depth, boolean mirrored) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, 0.0f, mirrored));
        return this;
    }

    public void func_78790_a(float offX, float offY, float offZ, int width, int height, int depth, float scaleFactor) {
        this.field_78804_l.add(new ModelBox((ModelRenderer)this, this.field_78803_o, this.field_78813_p, offX, offY, offZ, width, height, depth, scaleFactor));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setHasLighting(boolean hasLighting) {
        this.hasLighting = hasLighting;
    }

    public void setDoubleSided(boolean doubleSided) {
        this.doubleSided = doubleSided;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.field_78795_f;
        this.defaultRotationY = this.field_78796_g;
        this.defaultRotationZ = this.field_78808_h;
        this.defaultOffsetX = this.field_82906_o;
        this.defaultOffsetY = this.field_82908_p;
        this.defaultOffsetZ = this.field_82907_q;
        this.defaultPositionX = this.field_78800_c;
        this.defaultPositionY = this.field_78797_d;
        this.defaultPositionZ = this.field_78798_e;
    }

    public void resetToDefaultPose() {
        this.field_78795_f = this.defaultRotationX;
        this.field_78796_g = this.defaultRotationY;
        this.field_78808_h = this.defaultRotationZ;
        this.field_82906_o = this.defaultOffsetX;
        this.field_82908_p = this.defaultOffsetY;
        this.field_82907_q = this.defaultOffsetZ;
        this.field_78800_c = this.defaultPositionX;
        this.field_78797_d = this.defaultPositionY;
        this.field_78798_e = this.defaultPositionZ;
    }

    public void func_78792_a(ModelRenderer child) {
        super.func_78792_a(child);
        if (child instanceof ExtendedModelRenderer) {
            ExtendedModelRenderer advancedChild = (ExtendedModelRenderer)child;
            advancedChild.setParent(this);
        }
    }

    public ExtendedModelRenderer getParent() {
        return this.parent;
    }

    public void setParent(ExtendedModelRenderer parent) {
        this.parent = parent;
    }

    public void parentedPostRender(float scale) {
        if (this.parent != null) {
            this.parent.parentedPostRender(scale);
        }
        this.func_78794_c(scale);
    }

    public void renderWithParents(float scale) {
        if (this.parent != null) {
            this.parent.renderWithParents(scale);
        }
        this.func_78785_a(scale);
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            GlStateManager.func_179094_E();
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.func_179109_b((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
                GlStateManager.func_179152_a((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            }
            if (!this.doubleSided) {
                GlStateManager.func_179089_o();
            }
            if (!this.hasLighting) {
                GlStateManager.func_179140_f();
            }
            if (this.opacity != 1.0f) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            }
            GlStateManager.func_179148_o((int)this.displayList);
            if (!(this.scaleChildren || this.scaleX == 1.0f && this.scaleY == 1.0f && this.scaleZ == 1.0f)) {
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
                GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)((float)Math.toDegrees(this.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            if (!this.hasLighting) {
                GlStateManager.func_179145_e();
            }
            if (!this.doubleSided) {
                GlStateManager.func_179129_p();
            }
            if (this.opacity != 1.0f) {
                GlStateManager.func_179084_k();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.field_78805_m != null) {
                for (ModelRenderer childModel : this.field_78805_m) {
                    childModel.func_78785_a(scale);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        for (ModelBox box : this.field_78804_l) {
            box.func_178780_a(buffer, scale);
        }
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    public AdvancedModelBase getModel() {
        return this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float rotation = MathHelper.func_76134_b((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.field_78795_f += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.field_78808_h += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.field_78796_g += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.field_78797_d += bob;
    }

    public ExtendedModelRenderer setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.field_78803_o = textureOffsetX;
        this.field_78813_p = textureOffsetY;
        return this;
    }

    public void transitionTo(ExtendedModelRenderer to, float timer, float maxTime) {
        this.field_78795_f += (to.field_78795_f - this.field_78795_f) / maxTime * timer;
        this.field_78796_g += (to.field_78796_g - this.field_78796_g) / maxTime * timer;
        this.field_78808_h += (to.field_78808_h - this.field_78808_h) / maxTime * timer;
        this.field_78800_c += (to.field_78800_c - this.field_78800_c) / maxTime * timer;
        this.field_78797_d += (to.field_78797_d - this.field_78797_d) / maxTime * timer;
        this.field_78798_e += (to.field_78798_e - this.field_78798_e) / maxTime * timer;
        this.field_82906_o += (to.field_82906_o - this.field_82906_o) / maxTime * timer;
        this.field_82908_p += (to.field_82908_p - this.field_82908_p) / maxTime * timer;
        this.field_82907_q += (to.field_82907_q - this.field_82907_q) / maxTime * timer;
    }
}

