/*
 * Decompiled with CFR 0.152.
 */
package com.expensivekoala.refined_avaritia.gui;

import com.expensivekoala.refined_avaritia.RefinedAvaritia;
import com.expensivekoala.refined_avaritia.gui.ContainerExtremePatternEncoder;
import com.expensivekoala.refined_avaritia.network.MessageClearExtremePattern;
import com.expensivekoala.refined_avaritia.network.MessageCreateExtremePattern;
import com.expensivekoala.refined_avaritia.network.MessageSetAvaritiaPattern;
import com.expensivekoala.refined_avaritia.network.MessageSetOredictExtremePattern;
import com.expensivekoala.refined_avaritia.network.MessageSetTableSize;
import com.expensivekoala.refined_avaritia.tile.TileExtremePatternEncoder;
import com.expensivekoala.refined_avaritia.util.ExtendedCraftingUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiExtremePatternEncoder
extends GuiContainer {
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final String GUI_TEXTURE = "gui/extreme_pattern_encoder.png";
    private static final String GUI_BUTTON = "gui/button.png";
    int screenWidth = 238;
    int screenHeight = 256;
    int lastButtonId;
    ExtendedCraftingUtil.TableSize selectedTable = ExtendedCraftingUtil.TableSize.ULTIMATE;
    TileExtremePatternEncoder tile;
    GuiCheckBox oredictPattern;
    public GuiCheckBox avaritia;

    public GuiExtremePatternEncoder(ContainerExtremePatternEncoder container, TileExtremePatternEncoder tile) {
        super((Container)container);
        this.tile = tile;
        this.field_146999_f = this.screenWidth;
        this.field_147000_g = this.screenHeight;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.lastButtonId = 0;
        this.oredictPattern = this.addCheckBox(this.field_147003_i + 175, this.field_147009_r + 156, I18n.func_135052_a((String)"misc.refined_avaritia:oredict", (Object[])new Object[0]), this.tile.getOredictPattern());
        if (Loader.isModLoaded((String)"avaritia") && Loader.isModLoaded((String)"extendedcrafting")) {
            this.avaritia = this.addCheckBox(this.field_147003_i + 175, this.field_147009_r + 144, I18n.func_135052_a((String)"misc.refined_avaritia:avaritia", (Object[])new Object[0]), this.tile.isAvaritia());
            if (this.avaritia.isChecked()) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.ULTIMATE));
                this.selectedTable = ExtendedCraftingUtil.TableSize.ULTIMATE;
                this.tile.setTableSize(this.selectedTable);
            }
        }
        this.selectedTable = this.tile.getTableSize();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        try {
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public GuiCheckBox addCheckBox(int x, int y, String text, boolean checked) {
        GuiCheckBox checkBox = new GuiCheckBox(this.lastButtonId++, x, y, text, checked);
        this.field_146292_n.add(checkBox);
        return checkBox;
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.inBounds(200, 59, 16, 16, mouseX, mouseY) && this.tile.canCreatePattern();
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        return this.inBounds(176, 8, 7, 7, mouseX, mouseY);
    }

    private boolean isOverBasic(int mouseX, int mouseY) {
        return this.inBounds(-14, 173, 50, 32, mouseX, mouseY);
    }

    private boolean isOverAdvanced(int mouseX, int mouseY) {
        return this.inBounds(202, 173, 50, 32, mouseX, mouseY);
    }

    private boolean isOverElite(int mouseX, int mouseY) {
        return this.inBounds(-14, 210, 50, 32, mouseX, mouseY);
    }

    private boolean isOverUltimate(int mouseX, int mouseY) {
        return this.inBounds(202, 210, 50, 32, mouseX, mouseY);
    }

    public boolean inBounds(int x, int y, int w, int h, int ox, int oy) {
        return ox >= x && ox <= x + w && oy >= y && oy <= y + h;
    }

    private boolean slotEnabled(int x, int y) {
        switch (this.selectedTable) {
            case BASIC: {
                return x > 2 && x <= 5 && y > 2 && y <= 5;
            }
            case ADVANCED: {
                return x > 1 && x <= 6 && y > 1 && y <= 6;
            }
            case ELITE: {
                return x > 0 && x <= 7 && y > 0 && y <= 7;
            }
            case ULTIMATE: {
                return true;
            }
        }
        return false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.oredictPattern) {
            this.tile.setOredictPattern(this.oredictPattern.isChecked());
            RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetOredictExtremePattern(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), this.oredictPattern.isChecked()));
        }
        if (Loader.isModLoaded((String)"avaritia") && Loader.isModLoaded((String)"extendedcrafting") && button == this.avaritia) {
            this.tile.setAvaritia(this.avaritia.isChecked());
            RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetAvaritiaPattern(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), this.avaritia.isChecked()));
            if (this.avaritia.isChecked()) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.ULTIMATE));
                this.selectedTable = ExtendedCraftingUtil.TableSize.ULTIMATE;
                this.tile.setTableSize(this.selectedTable);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageClearExtremePattern(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p()));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageCreateExtremePattern(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p()));
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (Loader.isModLoaded((String)"extendedcrafting")) {
            if (this.avaritia != null && this.avaritia.isChecked()) {
                return;
            }
            if (this.isOverBasic(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.BASIC));
                this.selectedTable = ExtendedCraftingUtil.TableSize.BASIC;
                this.tile.setTableSize(this.selectedTable);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else if (this.isOverAdvanced(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.ADVANCED));
                this.selectedTable = ExtendedCraftingUtil.TableSize.ADVANCED;
                this.tile.setTableSize(this.selectedTable);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else if (this.isOverElite(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.ELITE));
                this.selectedTable = ExtendedCraftingUtil.TableSize.ELITE;
                this.tile.setTableSize(this.selectedTable);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            } else if (this.isOverUltimate(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                RefinedAvaritia.instance.network.sendToServer((IMessage)new MessageSetTableSize(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), ExtendedCraftingUtil.TableSize.ULTIMATE));
                this.selectedTable = ExtendedCraftingUtil.TableSize.ULTIMATE;
                this.tile.setTableSize(this.selectedTable);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture("refined_avaritia", GUI_TEXTURE);
        this.drawTexture(this.field_147003_i, this.field_147009_r, 0, 0, this.screenWidth, this.screenHeight);
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                if (this.slotEnabled(x, y)) continue;
                this.drawTexture(this.field_147003_i + 11 + x * 18, this.field_147009_r + 7 + y * 18, 238, 49, 18, 18);
            }
        }
        int ty = 0;
        if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            ty = 1;
        }
        if (this.tile != null && !this.tile.canCreatePattern()) {
            ty = 2;
        }
        this.drawTexture(this.field_147003_i + 199, this.field_147009_r + 57, 240, ty * 16, 16, 16);
        if (Loader.isModLoaded((String)"extendedcrafting")) {
            if (this.avaritia != null && this.avaritia.isChecked()) {
                return;
            }
            this.bindTexture("refined_avaritia", GUI_BUTTON);
            this.drawTexture(this.field_147003_i - 14, this.field_147009_r + 173, this.selectedTable == ExtendedCraftingUtil.TableSize.BASIC ? 0 : 50, 0, 50, 32);
            this.field_146289_q.func_78276_b("3x3", this.field_147003_i - 14 + 16, this.field_147009_r + 173 + 12, this.field_146289_q.func_175064_b('0'));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture("refined_avaritia", GUI_BUTTON);
            this.drawTexture(this.field_147003_i + 202, this.field_147009_r + 173, this.selectedTable == ExtendedCraftingUtil.TableSize.ADVANCED ? 0 : 50, 0, 50, 32);
            this.field_146289_q.func_78276_b("5x5", this.field_147003_i + 202 + 16, this.field_147009_r + 173 + 12, this.field_146289_q.func_175064_b('0'));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture("refined_avaritia", GUI_BUTTON);
            this.drawTexture(this.field_147003_i - 14, this.field_147009_r + 210, this.selectedTable == ExtendedCraftingUtil.TableSize.ELITE ? 0 : 50, 0, 50, 32);
            this.field_146289_q.func_78276_b("7x7", this.field_147003_i - 14 + 16, this.field_147009_r + 210 + 12, this.field_146289_q.func_175064_b('0'));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture("refined_avaritia", GUI_BUTTON);
            this.drawTexture(this.field_147003_i + 202, this.field_147009_r + 210, this.selectedTable == ExtendedCraftingUtil.TableSize.ULTIMATE ? 0 : 50, 0, 50, 32);
            this.field_146289_q.func_78276_b("9x9", this.field_147003_i + 202 + 16, this.field_147009_r + 210 + 12, this.field_146289_q.func_175064_b('0'));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isOverClear(mouseX -= this.field_147003_i, mouseY -= this.field_147009_r)) {
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)"misc.refined_avaritia:clear_tooltip", (Object[])new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)"misc.refined_avaritia:create_pattern_tooltip", (Object[])new Object[0]));
        }
    }

    private void bindTexture(String base, String file) {
        String id = base + ":" + file;
        if (!TEXTURE_CACHE.containsKey(id)) {
            TEXTURE_CACHE.put(id, new ResourceLocation(base, "textures/" + file));
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_CACHE.get(id));
    }

    public void drawTooltip(@Nonnull ItemStack stack, int x, int y, String lines) {
        this.drawTooltip(stack, x, y, Arrays.asList(lines.split("\n")));
    }

    public void drawTooltip(int x, int y, String lines) {
        this.drawTooltip(ItemStack.field_190927_a, x, y, lines);
    }

    public void drawTooltip(@Nonnull ItemStack stack, int x, int y, List<String> lines) {
        GlStateManager.func_179140_f();
        GuiUtils.drawHoveringText((ItemStack)stack, lines, (int)x, (int)y, (int)(this.field_146294_l - this.field_147003_i), (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        GlStateManager.func_179145_e();
    }

    public void drawTexture(int x, int y, int textureX, int textureY, int width, int height) {
        this.func_73729_b(x, y, textureX, textureY, width, height);
    }
}

